/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.finding;

import com.exasol.projectkeeper.Logger;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFindingGroup;
import java.util.ArrayList;
import java.util.List;

public class FindingsFixer {
    private final Logger logger;

    public FindingsFixer(Logger logger) {
        this.logger = logger;
    }

    public List<SimpleValidationFinding> fixFindings(List<ValidationFinding> findings) {
        FixingVisitor visitor = new FixingVisitor(this.logger);
        for (ValidationFinding finding : findings) {
            finding.accept(visitor);
        }
        return visitor.getUnfixed();
    }

    private static class FixingVisitor
    implements ValidationFinding.Visitor {
        private final Logger logger;
        private final List<SimpleValidationFinding> unfixed = new ArrayList<SimpleValidationFinding>();

        private FixingVisitor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void visit(SimpleValidationFinding finding) {
            if (finding.hasFix()) {
                finding.getFix().fixError(this.logger);
            } else {
                this.unfixed.add(finding);
            }
        }

        @Override
        public void visit(ValidationFindingGroup finding) {
            for (ValidationFinding eachFinding : finding.getFindings()) {
                eachFinding.accept(this);
            }
            finding.getPostFix().run();
        }

        public List<SimpleValidationFinding> getUnfixed() {
            return this.unfixed;
        }
    }
}

