/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.finding;

import com.exasol.projectkeeper.Logger;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class SimpleValidationFinding
implements ValidationFinding {
    private final String message;
    private final boolean isOptional;
    private final Fix fix;

    public static List<SimpleValidationFinding> blockers(List<SimpleValidationFinding> findings) {
        return findings.stream().filter(Predicate.not(SimpleValidationFinding::isOptional)).collect(Collectors.toList());
    }

    public SimpleValidationFinding(String message, boolean isOptional, Fix fix) {
        this.message = message;
        this.isOptional = isOptional;
        this.fix = fix;
    }

    public static Builder withMessage(String message) {
        return new Builder(message);
    }

    public String getMessage() {
        return this.message;
    }

    public Fix getFix() {
        return Objects.requireNonNullElseGet(this.fix, () -> log -> {});
    }

    public boolean hasFix() {
        return this.fix != null;
    }

    @Override
    public void accept(ValidationFinding.Visitor visitor) {
        visitor.visit(this);
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public String toString() {
        return "SimpleValidationFinding [message=" + this.message + ", isOptional=" + this.isOptional + ", fix=" + this.fix + "]";
    }

    public int hashCode() {
        return Objects.hash(this.message, this.isOptional, this.fix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleValidationFinding other = (SimpleValidationFinding)obj;
        return Objects.equals(this.message, other.message) && this.isOptional == other.isOptional && Objects.equals(this.fix, other.fix);
    }

    public static class Builder {
        private final String message;
        private boolean isOptional = false;
        private Fix fix;

        private Builder(String message) {
            this.message = message;
        }

        public Builder andFix(Fix fix) {
            this.fix = fix;
            return this;
        }

        public Builder optional(boolean value) {
            this.isOptional = value;
            return this;
        }

        public SimpleValidationFinding build() {
            return new SimpleValidationFinding(this.message, this.isOptional, this.fix);
        }
    }

    @FunctionalInterface
    public static interface Fix {
        public void fixError(Logger var1);
    }
}

