/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.RepoInfo;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.shared.config.ParentPomRef;
import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.validators.OwnVersionValidator;
import com.exasol.projectkeeper.validators.files.RequiredFileValidator;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFindingGroup;
import com.exasol.projectkeeper.validators.pom.PomFileGenerator;
import com.exasol.projectkeeper.validators.pom.XmlHelper;
import com.exasol.projectkeeper.validators.pom.io.PomFileReader;
import com.exasol.projectkeeper.validators.pom.io.PomFileWriter;
import com.exasol.projectkeeper.xpath.XPathErrorHandlingWrapper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PomFileValidator
implements Validator {
    private static final String PARENT_POM_MITIGATION = "Check the project-keeper user guide if you need a parent pom.";
    private static final String MUST_DECLARE_GENERATED_PARENT = " The pom must declare {{generated parent}} as parent pom.";
    private final Path projectDirectory;
    final Collection<ProjectKeeperModule> enabledModules;
    private final Path pomFilePath;
    private final ParentPomRef parentPomRef;
    private final RepoInfo repoInfo;

    public PomFileValidator(Path projectDirectory, Collection<ProjectKeeperModule> enabledModules, Path pomFilePath, ParentPomRef parentPomRef, RepoInfo repoInfo) {
        this.projectDirectory = projectDirectory;
        this.enabledModules = enabledModules;
        this.pomFilePath = pomFilePath;
        this.parentPomRef = parentPomRef;
        this.repoInfo = repoInfo;
    }

    @Override
    public List<ValidationFinding> validate() {
        try {
            Document pom = PomFileReader.parse(this.pomFilePath);
            String version = this.getProjectVersion(pom);
            String artifactId = this.getRequiredTextValue(pom, "/project/artifactId") + "-generated-parent";
            String groupId = this.getGroupId(pom);
            ArrayList<ValidationFinding> findings = new ArrayList<ValidationFinding>();
            this.validateGroupId(groupId).ifPresent(findings::add);
            this.validateUrlTag(pom).ifPresent(findings::add);
            findings.addAll(this.validateOwnVersion(pom));
            Path generatedPomPath = this.pomFilePath.getParent().resolve("pk_generated_parent.pom");
            findings.addAll(this.validateParentTag(pom, version, artifactId, groupId, generatedPomPath));
            findings.addAll(this.validateGeneratedPomFile(groupId, artifactId, version, generatedPomPath));
            this.validationDescriptionExists(pom).ifPresent(findings::add);
            if (this.enabledModules.contains(ProjectKeeperModule.JAR_ARTIFACT)) {
                findings.addAll(this.validateAssemblyPlugin(pom, this.projectDirectory.relativize(this.pomFilePath)));
            }
            return this.wrapFindingsWithGroupThatWritesPom(pom, findings);
        }
        catch (InvalidPomException exception) {
            return List.of(SimpleValidationFinding.withMessage(exception.getMessage()).build());
        }
    }

    private List<ValidationFinding> validateOwnVersion(Document pom) {
        Node node = XPathErrorHandlingWrapper.runXPath(pom, "/project/build/plugins/plugin[groupId = 'com.exasol' and artifactId = 'project-keeper-maven-plugin']/version");
        if (node == null) {
            return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"W-PK-CORE-151").message("Pom file {{file}} contains no reference to project-keeper-maven-plugin.", new Object[]{this.pomFilePath}).toString()).optional(true).build());
        }
        OwnVersionValidator.Updater updater = version -> log -> node.setTextContent(version);
        return OwnVersionValidator.forMavenPlugin(node.getTextContent(), updater).validate();
    }

    private Optional<SimpleValidationFinding> validateUrlTag(Document document) {
        String expectedUrl = "https://github.com/exasol/" + this.repoInfo.getRepoName() + "/";
        return this.validateTagContent(document, "/project", "url", expectedUrl);
    }

    private Optional<SimpleValidationFinding> validateTagContent(Document document, String parentXPath, String tagName, String expectedValue) {
        Node parent = XPathErrorHandlingWrapper.runXPath(document, parentXPath);
        Node node = XPathErrorHandlingWrapper.runXPath(parent, tagName);
        if (node == null) {
            return Optional.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-123").message("Invalid pom file {{file}}: Missing required property {{xpath}}.", new Object[]{this.projectDirectory.relativize(this.pomFilePath), parentXPath + "/" + tagName}).mitigation("The expected value is {{expected value}}.", new Object[]{expectedValue}).toString()).andFix(log -> XmlHelper.addTextElement(parent, tagName, expectedValue)).build());
        }
        if (!node.getTextContent().equals(expectedValue)) {
            return Optional.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-122").message("Invalid pom file {{file}}: Invalid value {{actual value}} for property {{xpath}}.", new Object[]{this.projectDirectory.relativize(this.pomFilePath), node.getTextContent(), parentXPath + "/" + tagName}).mitigation("The expected value is {{expected value}}.", new Object[]{expectedValue}).toString()).andFix(log -> node.setTextContent(expectedValue)).build());
        }
        return Optional.empty();
    }

    private Optional<SimpleValidationFinding> validateGroupId(String groupId) {
        if (!groupId.equals("com.exasol")) {
            return Optional.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-121").message("Invalid pom file {{file}}: Invalid groupId {{groupId}}.", new Object[]{this.projectDirectory.relativize(this.pomFilePath), groupId}).mitigation("Manually set the groupId to 'com.exasol'.", new Object[0]).toString()).build());
        }
        return Optional.empty();
    }

    private Optional<ValidationFinding> validationDescriptionExists(Document document) {
        if (XPathErrorHandlingWrapper.runXPath(document, "/project/description") == null) {
            return Optional.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-120").message("Invalid pom file {{file}}: Missing required property {{property|u}}.", new Object[]{this.projectDirectory.relativize(this.pomFilePath), "/project/description"}).mitigation("Please manually add a description.", new Object[0]).toString()).build());
        }
        return Optional.empty();
    }

    private List<ValidationFinding> wrapFindingsWithGroupThatWritesPom(Document pom, List<ValidationFinding> findings) {
        if (this.hasFindingWithFix(findings)) {
            return List.of(new ValidationFindingGroup(findings, () -> PomFileWriter.writeFile(pom, this.pomFilePath)));
        }
        return findings;
    }

    private boolean hasFindingWithFix(List<ValidationFinding> findings) {
        return findings.stream().anyMatch(finding -> finding instanceof ValidationFindingGroup || finding instanceof SimpleValidationFinding && ((SimpleValidationFinding)finding).hasFix());
    }

    private String getProjectVersion(Document pom) throws InvalidPomException {
        return Stream.of(this.versionFrom(XPathErrorHandlingWrapper.runXPath(pom, "/project/version")), this.versionFrom(this.parentPomRef), this.versionFrom(XPathErrorHandlingWrapper.runXPath(pom, "/project/parent/version"))).filter(Objects::nonNull).findFirst().orElseThrow(() -> new InvalidPomException(ExaError.messageBuilder((String)"E-PK-CORE-111").message("Failed to detect project version.", new Object[0]).mitigation("Please either set {{xpath1|u}} or {{xpath2}} in file {{pom file|u}}", new Object[]{"/project/version", "/project/parent/version", this.projectDirectory.relativize(this.pomFilePath)}).mitigation("or add version to file {{configuration file|u}}.", new Object[]{".project-keeper.yml"}).toString()));
    }

    private String versionFrom(Node node) {
        return node == null ? null : node.getTextContent();
    }

    private String versionFrom(ParentPomRef ref) {
        return ref == null ? null : ref.getVersion();
    }

    private List<ValidationFinding> validateAssemblyPlugin(Node pom, Path relativePomPath) {
        Node finalNameProperty = XPathErrorHandlingWrapper.runXPath(pom, "/project/build/plugins/plugin[artifactId/text() = 'maven-assembly-plugin']/configuration/finalName");
        if (finalNameProperty == null || finalNameProperty.getTextContent().isBlank()) {
            return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-105").message("Invalid pom file {{file}}: Missing required property finalName property in maven-assembly-plugin.", new Object[]{relativePomPath}).mitigation("Use the following template and set finalName:\n<plugin>\n    <artifactId>maven-assembly-plugin</artifactId>\n    <groupId>org.apache.maven.plugins</groupId>\n    <configuration>\n        <finalName>NAME_OF_YOUR_JAR</finalName>\n    </configuration>\n</plugin>", new Object[0]).toString()).build());
        }
        return Collections.emptyList();
    }

    private List<ValidationFinding> validateParentTag(Document pom, String version, String artifactId, String groupId, Path generatedPomPath) {
        Node parentTag = XPathErrorHandlingWrapper.runXPath(pom, "/project/parent");
        if (parentTag == null) {
            return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-103").message("Missing parent declaration in {{pom file}}", new Object[]{this.projectDirectory.relativize(this.pomFilePath)}).toString()).andFix(this.getAddParentToPomFileFix(pom, version, artifactId, groupId, generatedPomPath)).build());
        }
        return this.validateExistingParentTag(version, artifactId, groupId, generatedPomPath, parentTag);
    }

    private List<ValidationFinding> validateExistingParentTag(String version, String artifactId, String groupId, Path generatedPomPath, Node parentTag) {
        ArrayList<ValidationFinding> findings = new ArrayList<ValidationFinding>();
        this.checkParentProperty(generatedPomPath, parentTag, "artifactId", artifactId).ifPresent(findings::add);
        this.checkParentProperty(generatedPomPath, parentTag, "groupId", groupId).ifPresent(findings::add);
        this.checkParentRelativePath(generatedPomPath, parentTag, this.pomFilePath.getParent().relativize(generatedPomPath)).ifPresent(findings::add);
        this.checkParentVersion(version, generatedPomPath, parentTag, !findings.isEmpty()).ifPresent(findings::add);
        return findings;
    }

    private Optional<SimpleValidationFinding> checkParentVersion(String version, Path generatedPomPath, Node parentTag, boolean hasOtherFindings) {
        Node node = XPathErrorHandlingWrapper.runXPath(parentTag, "version");
        if (node == null || !version.equals(node.getTextContent())) {
            SimpleValidationFinding.Builder findingBuilder = SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-118").message("Invalid pom file {{file}}: Invalid {{parent version xpath|u}}. Expected value is {{expected}}. The pom must declare {{generated parent}} as parent pom.", new Object[]{this.projectDirectory.relativize(this.pomFilePath), "/project/parent/version", version, this.projectDirectory.relativize(generatedPomPath)}).mitigation(PARENT_POM_MITIGATION, new Object[0]).toString());
            if (!hasOtherFindings && node != null) {
                findingBuilder.andFix(log -> node.setTextContent(version));
            }
            SimpleValidationFinding finding = findingBuilder.build();
            return Optional.of(finding);
        }
        return Optional.empty();
    }

    private Optional<ValidationFinding> checkParentRelativePath(Path generatedPomPath, Node parentTag, Path expectedValue) {
        Node node = XPathErrorHandlingWrapper.runXPath(parentTag, "relativePath");
        if (node == null || !this.comparePaths(expectedValue, Path.of(node.getTextContent(), new String[0]))) {
            return Optional.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-112").message("Invalid pom file {{file}}: Invalid {{parent relative path|u}}. Expected value is {{expected}}. The pom must declare {{generated parent}} as parent pom.", new Object[]{this.projectDirectory.relativize(this.pomFilePath), "/project/parent/relativePath", expectedValue, this.projectDirectory.relativize(generatedPomPath)}).mitigation(PARENT_POM_MITIGATION, new Object[0]).toString()).build());
        }
        return Optional.empty();
    }

    private boolean comparePaths(Path expectedValue, Path other) {
        return other.normalize().equals(expectedValue.normalize());
    }

    private Optional<ValidationFinding> checkParentProperty(Path generatedPomPath, Node parentTag, String property, String expectedValue) {
        Node node = XPathErrorHandlingWrapper.runXPath(parentTag, property);
        if (node == null || !node.getTextContent().equals(expectedValue)) {
            return Optional.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-104").message("Invalid pom file {{file}}: Invalid {{xpath|u}}. Expected value is {{expected}}. The pom must declare {{generated parent}} as parent pom.", new Object[]{this.projectDirectory.relativize(this.pomFilePath), "/project/parent/" + property, expectedValue, this.projectDirectory.relativize(generatedPomPath)}).mitigation(PARENT_POM_MITIGATION, new Object[0]).toString()).build());
        }
        return Optional.empty();
    }

    private SimpleValidationFinding.Fix getAddParentToPomFileFix(Document pom, String version, String artifactId, String groupId, Path generatedPomPath) {
        return log -> {
            Node project = XPathErrorHandlingWrapper.runXPath(pom, "/project");
            Element parent = pom.createElement("parent");
            XmlHelper.addTextElement(parent, "artifactId", artifactId);
            XmlHelper.addTextElement(parent, "groupId", groupId);
            XmlHelper.addTextElement(parent, "version", version);
            XmlHelper.addTextElement(parent, "relativePath", this.pomFilePath.getParent().relativize(generatedPomPath).toString());
            project.appendChild(parent);
        };
    }

    private List<ValidationFinding> validateGeneratedPomFile(String groupId, String artifactId, String version, Path generatedPomPath) {
        String generatedContent = new PomFileGenerator().generatePomContent(this.enabledModules, groupId, artifactId, version, this.parentPomRef, this.repoInfo);
        return new RequiredFileValidator().validateFile(this.projectDirectory, generatedPomPath, RequiredFileValidator.withContentEqualTo(generatedContent));
    }

    private String getGroupId(Document pom) throws InvalidPomException {
        Node node = XPathErrorHandlingWrapper.runXPath(pom, "/project/groupId");
        if (node != null) {
            return node.getTextContent();
        }
        Node parentGroupIdNode = XPathErrorHandlingWrapper.runXPath(pom, "/project/parent/groupId");
        if (parentGroupIdNode != null) {
            return parentGroupIdNode.getTextContent();
        }
        throw new InvalidPomException(ExaError.messageBuilder((String)"E-PK-CORE-102").message("Invalid pom file {{file}}: Missing required property 'groupId'.", new Object[]{this.projectDirectory.relativize(this.pomFilePath)}).mitigation("Please either set {{groupId|u}} or {{parent groupId|u}}.", new Object[]{"/project/groupId", "/project/parent/groupId"}).toString());
    }

    private String getRequiredTextValue(Node pom, String xPath) throws InvalidPomException {
        Node node = XPathErrorHandlingWrapper.runXPath(pom, xPath);
        if (node == null) {
            throw new InvalidPomException(ExaError.messageBuilder((String)"E-PK-CORE-101").message("Invalid pom file {{file}}: Missing required property {{property|u}}.", new Object[]{this.projectDirectory.relativize(this.pomFilePath), xPath}).mitigation("Please set the property manually.", new Object[0]).toString());
        }
        return node.getTextContent();
    }

    private static class InvalidPomException
    extends Exception {
        private static final long serialVersionUID = 6050603678193596784L;

        public InvalidPomException(String message) {
            super(message);
        }
    }

    static class XPath {
        static final String PROJECT = "/project";
        static final String PROJECT_KEEPER_VERSION = "/project/build/plugins/plugin[groupId = 'com.exasol' and artifactId = 'project-keeper-maven-plugin']/version";
        static final String VERSION = "/project/version";
        static final String ARTIFACT_ID = "/project/artifactId";
        static final String PARENT = "/project/parent";
        static final String PARENT_VERSION = "/project/parent/version";
        static final String GROUP_ID = "/project/groupId";
        static final String PARENT_GROUP_ID = "/project/parent/groupId";
        static final String PARENT_RELATIVE_PATH = "/project/parent/relativePath";
        static final String FINAL_NAME = "/project/build/plugins/plugin[artifactId/text() = 'maven-assembly-plugin']/configuration/finalName";
        static final String DESCRIPTION = "/project/description";

        private XPath() {
        }
    }
}

