/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom;

import com.exasol.errorreporting.ExaError;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class PomRenderer {
    private PomRenderer() {
    }

    public static String renderPom(Node xmlDocument) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domSource = new DOMSource(xmlDocument);
            ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(targetStream);
            transformer.transform(domSource, streamResult);
            return targetStream.toString(StandardCharsets.UTF_8);
        }
        catch (TransformerException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-74").message("Failed to render XML document.", new Object[0]).toString(), exception);
        }
    }
}

