/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom.builder;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.pom.builder.ChildrenBuilder;
import com.exasol.projectkeeper.validators.pom.builder.NodeBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class DocumentBuilder
extends ChildrenBuilder<DocumentBuilder> {
    DocumentBuilder() {
    }

    public Document build() {
        Document document = this.createDocument();
        for (NodeBuilder child : this.children) {
            document.appendChild(child.build(document));
        }
        return document;
    }

    private Document createDocument() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(false);
            return document;
        }
        catch (ParserConfigurationException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-PK-CORE-109").message("Failed to create document.", new Object[0]).ticketMitigation().toString(), exception);
        }
    }

    @Override
    protected DocumentBuilder getThis() {
        return this;
    }
}

