/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom.plugin;

import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.validators.pom.plugin.PluginTemplateGenerator;
import com.exasol.projectkeeper.validators.pom.plugin.PluginTemplateReader;
import java.util.Collection;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ErrorCodeCrawlerPluginTemplateGenerator
implements PluginTemplateGenerator {
    private static final String TEMPLATE = "maven_templates/error-code-crawler-maven-plugin.xml";

    @Override
    public Optional<Node> generateTemplate(Collection<ProjectKeeperModule> enabledModules) {
        Node pluginTemplate = new PluginTemplateReader().readPluginTemplate(TEMPLATE);
        if (enabledModules.contains(ProjectKeeperModule.LOMBOK)) {
            this.addLombokSourcePathConfig(pluginTemplate);
        }
        return Optional.of(pluginTemplate);
    }

    private void addLombokSourcePathConfig(Node pluginTemplate) {
        Document document = pluginTemplate.getOwnerDocument();
        Element sourcePaths = document.createElement("sourcePaths");
        sourcePaths.appendChild(this.createSourcePathElement(document, "target/delombok/main"));
        Element configuration = document.createElement("configuration");
        configuration.appendChild(sourcePaths);
        pluginTemplate.appendChild(configuration);
    }

    private Element createSourcePathElement(Document document, String sourcePath) {
        Element sourcePathElement = document.createElement("sourcePath");
        sourcePathElement.setTextContent(sourcePath);
        return sourcePathElement;
    }
}

