/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.pom.DefaultMavenProjectFromFileReader;
import com.exasol.projectkeeper.pom.MavenModelFromRepositoryReader;
import com.exasol.projectkeeper.pom.MavenProjectFromFileReader;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependencies;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeReport;
import com.exasol.projectkeeper.shared.mavenprojectcrawler.CrawledMavenProject;
import com.exasol.projectkeeper.shared.mavenprojectcrawler.MavenProjectCrawlResult;
import com.exasol.projectkeeper.shared.mavenprojectcrawler.ResponseCoder;
import com.exasol.projectkeeper.validators.ArtifactNameReader;
import com.exasol.projectkeeper.validators.changesfile.DependencyUpdateReader;
import com.exasol.projectkeeper.validators.dependencies.ProjectDependencyReader;
import java.io.File;
import java.util.HashMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="crawl", requiresProject=false)
public class MavenProjectCrawlerMojo
extends AbstractMojo {
    private static final String PROPERTY_PROJECTS_TO_CRAWL = "projectsToCrawl";
    @Component
    RepositorySystem repositorySystem;
    @Parameter(property="projectsToCrawl", required=true)
    private String projectsToCrawl;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    public void execute() {
        String[] paths;
        if (this.projectsToCrawl == null || this.projectsToCrawl.isBlank()) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-MPC-64").message("Property {{property name}} is not defined or empty.", new Object[]{PROPERTY_PROJECTS_TO_CRAWL}).mitigation("Specify property with least one pom file.", new Object[0]).toString());
        }
        DefaultMavenProjectFromFileReader mavenProjectReader = new DefaultMavenProjectFromFileReader(this.mavenProjectBuilder, this.session);
        MavenModelFromRepositoryReader modelFromRepositoryReader = new MavenModelFromRepositoryReader(this.mavenProjectBuilder, this.session, this.repositorySystem);
        HashMap<String, CrawledMavenProject> crawledProjects = new HashMap<String, CrawledMavenProject>();
        for (String path : paths = this.projectsToCrawl.split(";")) {
            MavenProject project = this.readProject(mavenProjectReader, path);
            DependencyChangeReport dependencyChangeReport = new DependencyUpdateReader(mavenProjectReader, project.getBasedir().toPath(), project.getModel()).readDependencyChanges();
            ProjectDependencies dependencies = new ProjectDependencyReader(modelFromRepositoryReader, project).readDependencies();
            String javaVersion = project.getProperties().getProperty("java.version", null);
            String artifactName = new ArtifactNameReader(project).readFinalArtifactName();
            CrawledMavenProject crawledMavenProject = new CrawledMavenProject(dependencyChangeReport, dependencies, project.getVersion(), javaVersion, artifactName);
            crawledProjects.put(path, crawledMavenProject);
        }
        MavenProjectCrawlResult report = new MavenProjectCrawlResult(crawledProjects);
        String response = report.toJson();
        new ResponseCoder().printResponse(response);
    }

    private MavenProject readProject(MavenProjectFromFileReader mavenProjectReader, String pomPath) {
        try {
            return mavenProjectReader.readProject(new File(pomPath));
        }
        catch (MavenProjectFromFileReader.ReadFailedException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-MPC-1").message("Failed to crawl project {{path}}.", new Object[]{pomPath}).toString(), exception);
        }
    }
}

