/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

class TemporaryPomFile
implements AutoCloseable {
    private final Path pomFile;

    public TemporaryPomFile(String content) {
        try {
            this.pomFile = Files.createTempFile("pom-file-cache", ".xml", new FileAttribute[0]);
            Files.writeString(this.pomFile, (CharSequence)content, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-MPC-58").message("Failed to temporarily store pom file on disk.", new Object[0]).mitigation("Check the permissions for the temp directory of your OS.", new Object[0]).toString(), exception);
        }
    }

    @Override
    public void close() {
        try {
            Files.delete(this.pomFile);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-MPC-59").message("Failed to remove temporary cache file.", new Object[0]).mitigation("Check the file permissions.", new Object[0]).toString(), exception);
        }
    }

    public Path getPomFile() {
        return this.pomFile;
    }
}

