/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile.dependencies;

import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeReport;
import com.exasol.projectkeeper.validators.changesfile.dependencies.MavenDependencyComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;

public class DependencyChangeReportReader {
    private final MavenDependencyComparator dependencyComparator = new MavenDependencyComparator();

    public DependencyChangeReport read(Model oldModel, Model newModel) {
        return DependencyChangeReport.builder().typed(BaseDependency.Type.COMPILE, this.sort(this.compareDependencies(oldModel, newModel, "compile"))).typed(BaseDependency.Type.RUNTIME, this.sort(this.compareDependencies(oldModel, newModel, "runtime"))).typed(BaseDependency.Type.TEST, this.sort(this.compareDependencies(oldModel, newModel, "test"))).typed(BaseDependency.Type.PLUGIN, this.sort(this.comparePluginDependencies(oldModel, newModel))).build();
    }

    private List<DependencyChange> compareDependencies(Model oldModel, Model newModel, String scope) {
        List<Dependency> oldDependencies = this.filterDependenciesByScope(oldModel, scope);
        List<Dependency> newDependencies = this.filterDependenciesByScope(newModel, scope);
        return this.dependencyComparator.compare(oldDependencies, newDependencies);
    }

    private List<DependencyChange> comparePluginDependencies(Model oldModel, Model newModel) {
        List<Dependency> oldPluginDependencies = this.convertPluginsToDependencies(oldModel);
        List<Dependency> newPluginDependencies = this.convertPluginsToDependencies(newModel);
        return this.dependencyComparator.compare(oldPluginDependencies, newPluginDependencies);
    }

    private List<Dependency> filterDependenciesByScope(Model model, String scope) {
        return model.getDependencies().stream().filter(dependency -> scope.equals("compile") && (dependency.getScope() == null || dependency.getScope().equals("")) || scope.equals(dependency.getScope())).collect(Collectors.toList());
    }

    private List<Dependency> convertPluginsToDependencies(Model model) {
        return model.getBuild().getPlugins().stream().map(this::convertPluginToDependency).collect(Collectors.toList());
    }

    private Dependency convertPluginToDependency(Plugin plugin) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(plugin.getGroupId());
        dependency.setArtifactId(plugin.getArtifactId());
        dependency.setVersion(plugin.getVersion());
        return dependency;
    }

    private List<DependencyChange> sort(List<DependencyChange> dependencyChanges) {
        ArrayList<DependencyChange> result = new ArrayList<DependencyChange>(dependencyChanges);
        result.sort(new AlphabeticalDependencyComparator());
        return result;
    }

    private static class AlphabeticalDependencyComparator
    implements Comparator<DependencyChange> {
        private AlphabeticalDependencyComparator() {
        }

        @Override
        public int compare(DependencyChange a, DependencyChange b) {
            return this.getComparableString(a).compareTo(this.getComparableString(b));
        }

        private String getComparableString(DependencyChange dependencyChange) {
            return dependencyChange.getGroupId() + dependencyChange.getArtifactId() + dependencyChange.getVersion();
        }
    }
}

