/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.plugin;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Logger;
import com.exasol.projectkeeper.ProjectKeeper;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractProjectKeeperMojo
extends AbstractMojo {
    @Parameter(property="project-keeper.skip", defaultValue="false")
    private String skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    private ProjectKeeper createProjectKeeper() {
        return ProjectKeeper.createProjectKeeper((Logger)new MvnLogger(this.getLog()), (Path)this.project.getBasedir().toPath(), (Path)Path.of(this.session.getLocalRepository().getBasedir(), new String[0]));
    }

    public final void execute() throws MojoFailureException {
        if (this.isEnabled()) {
            this.runProjectKeeper(this.createProjectKeeper());
        }
    }

    protected abstract void runProjectKeeper(ProjectKeeper var1) throws MojoFailureException;

    protected boolean isEnabled() {
        if ("true".equals(this.skip)) {
            this.getLog().info((CharSequence)"Skipping project-keeper.");
            return false;
        }
        if ("false".equals(this.skip)) {
            return true;
        }
        throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-MVNP-75").message("Invalid value {{value}} for property 'project-keeper.skip'.", new Object[]{this.skip}).mitigation("Please set the property to 'true' or 'false'.", new Object[0]).toString());
    }

    private static class MvnLogger
    implements Logger {
        private final Log mvnLog;

        public void info(String message) {
            this.mvnLog.info((CharSequence)message);
        }

        public void warn(String message) {
            this.mvnLog.warn((CharSequence)message);
        }

        public void error(String message) {
            this.mvnLog.error((CharSequence)message);
        }

        @Generated
        public MvnLogger(Log mvnLog) {
            this.mvnLog = mvnLog;
        }
    }
}

