/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.s3;

import com.exasol.spark.common.ExasolOptions;
import com.exasol.spark.common.Option;

public abstract class AbstractImportExportQueryGenerator {
    private static final String DEFAULT_S3_ENDPOINT = "amazonaws.com";
    protected final ExasolOptions options;

    public AbstractImportExportQueryGenerator(ExasolOptions options) {
        this.options = options;
    }

    public String getIdentifier() {
        String awsAccessKeyId = this.options.get(Option.AWS_ACCESS_KEY_ID.key());
        String awsSecretAccessKey = this.options.get(Option.AWS_SECRET_ACCESS_KEY.key());
        return "AT '" + this.escapeStringLiteral(this.getBucketURL()) + "'\nUSER '" + this.escapeStringLiteral(awsAccessKeyId) + "' IDENTIFIED BY '" + this.escapeStringLiteral(awsSecretAccessKey) + "'\n";
    }

    private String escapeStringLiteral(String input) {
        return input.replace("'", "''");
    }

    private String getBucketURL() {
        return "https://" + this.options.getS3Bucket() + ".s3." + this.getS3Endpoint();
    }

    private String getS3Endpoint() {
        if (!this.options.containsKey(Option.S3_ENDPOINT_OVERRIDE.key())) {
            return DEFAULT_S3_ENDPOINT;
        }
        String override = this.options.get(Option.S3_ENDPOINT_OVERRIDE.key());
        if (this.options.hasEnabled(Option.REPLACE_LOCALHOST_BY_DEFAULT_S3_ENDPOINT.key())) {
            return override.replace("localhost", DEFAULT_S3_ENDPOINT);
        }
        return override;
    }
}

