/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.s3;

import com.exasol.errorreporting.ExaError;
import com.exasol.spark.common.ExasolOptions;
import com.exasol.spark.s3.ExasolConnectionException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;

public final class ExasolConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(ExasolConnectionFactory.class.getName());
    private final ExasolOptions options;

    public ExasolConnectionFactory(ExasolOptions options) {
        this.options = options;
    }

    public synchronized Connection getConnection() throws SQLException {
        this.verifyExasolJDBCDriverAvailable();
        String address = this.options.getJdbcUrl();
        String username = this.options.getUsername();
        LOGGER.fine(() -> "Getting connection at '" + address + "' with username '" + username + "' and password.");
        try {
            long start = System.currentTimeMillis();
            Connection connection = DriverManager.getConnection(address, username, this.options.getPassword());
            long connectionTime = System.currentTimeMillis() - start;
            LOGGER.info(() -> "Obtained connection to '" + address + "' in '" + connectionTime + "' milliseconds.");
            return connection;
        }
        catch (SQLException exception) {
            throw new ExasolConnectionException(ExaError.messageBuilder((String)"E-SEC-17").message("Could not connect to Exasol address on {{address}} with username {{username}}.", new Object[0]).parameter("address", (Object)address).parameter("username", (Object)username).mitigation("Please check that connection address, username and password are correct.", new Object[0]).toString(), exception);
        }
    }

    private void verifyExasolJDBCDriverAvailable() {
        String driverClassName = "com.exasol.jdbc.EXADriver";
        try {
            Class.forName("com.exasol.jdbc.EXADriver");
        }
        catch (ClassNotFoundException exception) {
            throw new ExasolConnectionException(ExaError.messageBuilder((String)"E-SEC-18").message("Failed to find Exasol JDBC Driver class {{class}}.", new Object[]{"com.exasol.jdbc.EXADriver"}).mitigation("Please make sure that Exasol JDBC Driver is installed.", new Object[0]).toString(), exception);
        }
    }
}

