/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.s3;

import com.exasol.errorreporting.ExaError;
import com.exasol.spark.common.ExasolOptions;
import com.exasol.spark.common.ExasolValidationException;
import com.exasol.spark.common.Option;
import com.exasol.spark.s3.ExasolS3ScanBuilder;
import com.exasol.spark.s3.ExasolWriteBuilderProvider;
import com.exasol.spark.s3.UUIDS3BucketKeyPathProvider;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class ExasolS3Table
implements SupportsRead,
SupportsWrite {
    private final StructType schema;
    private final Set<TableCapability> capabilities;

    public ExasolS3Table(StructType schema) {
        this.schema = schema;
        this.capabilities = Collections.unmodifiableSet(Stream.of(TableCapability.BATCH_READ, TableCapability.BATCH_WRITE).collect(Collectors.toSet()));
    }

    public String name() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExasolS3Table[").append("schema='" + this.schema().toString()).append("',").append("capabilities='" + this.capabilities().toString()).append("']");
        return builder.toString();
    }

    public StructType schema() {
        return this.schema;
    }

    public Set<TableCapability> capabilities() {
        return this.capabilities;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap map) {
        ExasolOptions options = ExasolOptions.from((CaseInsensitiveStringMap)map);
        this.validateNumberOfPartitions(options);
        this.updateSparkConfigurationForS3(options);
        return new ExasolS3ScanBuilder(options, this.schema, map);
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo defaultInfo) {
        ExasolOptions options = ExasolOptions.from((CaseInsensitiveStringMap)defaultInfo.options());
        this.validateHasTable(options);
        this.validateNumberOfPartitions(options);
        this.updateSparkConfigurationForS3(options);
        SparkSession sparkSession = SparkSession.active();
        String applicationId = sparkSession.sparkContext().applicationId();
        UUIDS3BucketKeyPathProvider prov = new UUIDS3BucketKeyPathProvider(applicationId);
        return new ExasolWriteBuilderProvider(options, prov).createWriteBuilder(this.schema, defaultInfo);
    }

    private void validateNumberOfPartitions(ExasolOptions options) {
        int maxAllowedPartitions;
        int numberOfPartitions = options.getNumberOfPartitions();
        if (numberOfPartitions > (maxAllowedPartitions = Integer.parseInt(Option.MAX_ALLOWED_NUMBER_OF_PARTITIONS.key()))) {
            throw new ExasolValidationException(ExaError.messageBuilder((String)"E-SEC-23").message("The number of partitions exceeds the supported maximum of {{MAXPARTITIONS}}.", new Object[]{maxAllowedPartitions}).mitigation("Please set parameter {{param}} to a lower value.", new Object[]{Option.NUMBER_OF_PARTITIONS.key()}).toString());
        }
    }

    private void validateHasTable(ExasolOptions options) {
        if (!options.hasTable()) {
            throw new ExasolValidationException(ExaError.messageBuilder((String)"E-SEC-19").message("Missing 'table' option when writing into Exasol database.", new Object[0]).mitigation("Please set 'table' property with fully qualified (e.g. 'schema_name.table_name') Exasol table name.", new Object[0]).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSparkConfigurationForS3(ExasolOptions options) {
        SparkSession sparkSession = SparkSession.active();
        Configuration configuration = sparkSession.sparkContext().hadoopConfiguration();
        synchronized (configuration) {
            Configuration conf = sparkSession.sparkContext().hadoopConfiguration();
            conf.set("fs.s3a.access.key", options.get(Option.AWS_ACCESS_KEY_ID.key()));
            conf.set("fs.s3a.secret.key", options.get(Option.AWS_SECRET_ACCESS_KEY.key()));
            if (options.containsKey(Option.AWS_CREDENTIALS_PROVIDER.key())) {
                conf.set("fs.s3a.aws.credentials.provider", options.get(Option.AWS_CREDENTIALS_PROVIDER.key()));
            } else {
                conf.set("fs.s3a.aws.credentials.provider", "org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider");
            }
            if (options.containsKey(Option.S3_ENDPOINT_OVERRIDE.key())) {
                conf.set("fs.s3a.endpoint", "http://" + options.get(Option.S3_ENDPOINT_OVERRIDE.key()));
            }
            if (options.hasEnabled(Option.S3_PATH_STYLE_ACCESS.key())) {
                conf.set("fs.s3a.path.style.access", "true");
            }
        }
    }
}

