/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.s3;

import com.exasol.errorreporting.ExaError;
import com.exasol.spark.common.ExasolOptions;
import com.exasol.spark.common.ExasolValidationException;
import com.exasol.spark.common.Option;
import com.exasol.spark.s3.DelegatingWriteBuilder;
import com.exasol.spark.s3.S3BucketKeyPathProvider;
import com.exasol.spark.s3.S3FileSystem;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVTable;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;

public final class ExasolWriteBuilderProvider {
    private static final Logger LOGGER = Logger.getLogger(ExasolWriteBuilderProvider.class.getName());
    private final ExasolOptions options;
    private final S3BucketKeyPathProvider s3BucketKeyPathProvider;

    public ExasolWriteBuilderProvider(ExasolOptions options, S3BucketKeyPathProvider s3BucketKeyPathProvider) {
        this.options = options;
        this.s3BucketKeyPathProvider = s3BucketKeyPathProvider;
    }

    public WriteBuilder createWriteBuilder(StructType schema, LogicalWriteInfo defaultInfo) {
        SparkSession sparkSession = SparkSession.active();
        String s3Bucket = this.options.getS3Bucket();
        String s3BucketKey = this.s3BucketKeyPathProvider.getS3BucketKeyForWriteLocation(defaultInfo.queryId());
        this.validateWritePathIsEmpty(s3Bucket, s3BucketKey);
        return this.createCSVWriteBuilder(sparkSession, schema, this.getUpdatedLogicalWriteInfo(defaultInfo, s3Bucket, s3BucketKey));
    }

    private void validateWritePathIsEmpty(String s3Bucket, String s3BucketKey) {
        try (S3FileSystem s3FileSystem = S3FileSystem.fromOptions(this.options);){
            if (!s3FileSystem.isEmpty(s3Bucket, Optional.of(s3BucketKey))) {
                throw new ExasolValidationException(ExaError.messageBuilder((String)"E-SEC-27").message("The intermediate write path is not empty.", new Object[0]).mitigation("Please ensure that the intermediate write path is empty or cleaned up properly.", new Object[0]).toString());
            }
        }
    }

    private WriteBuilder createCSVWriteBuilder(SparkSession sparkSession, StructType schema, LogicalWriteInfo info) {
        ExasolOptions updatedOptions = this.getUpdatedOptions((Map<String, String>)info.options());
        String intermediateDataPath = updatedOptions.get(Option.INTERMEDIATE_DATA_PATH.key());
        LOGGER.info(() -> "Writing intermediate data to the '" + intermediateDataPath + "' path for write job.");
        CSVTable csvTable = new CSVTable("", sparkSession, info.options(), this.getS3WritePath(intermediateDataPath), scala.Option.apply((Object)schema), CSVFileFormat.class);
        return new DelegatingWriteBuilder(updatedOptions, csvTable.newWriteBuilder(info));
    }

    private ExasolOptions getUpdatedOptions(Map<String, String> map) {
        ExasolOptions.Builder builder = ExasolOptions.builder().host(this.options.getHost()).port(this.options.getPort()).username(this.options.getUsername()).password(this.options.getPassword()).fingerprint(this.options.getFingerprint()).s3Bucket(this.options.getS3Bucket());
        if (this.options.hasTable()) {
            builder.table(this.options.getTable());
        } else {
            builder.query(this.options.getQuery());
        }
        builder.withOptionsMap(map);
        return builder.build();
    }

    private LogicalWriteInfo getUpdatedLogicalWriteInfo(final LogicalWriteInfo defaultInfo, String s3Bucket, String s3BucketKey) {
        final HashMap<String, Object> map = new HashMap<String, Object>(defaultInfo.options().asCaseSensitiveMap());
        map.put("header", "true");
        map.put("delimiter", ",");
        map.put("fs.s3a.committer.name", "magic");
        map.put("mapreduce.fileoutputcommitter.marksuccessfuljobs", "false");
        map.put(Option.INTERMEDIATE_DATA_PATH.key(), "s3a://" + Paths.get(s3Bucket, s3BucketKey).toString());
        map.put(Option.WRITE_S3_BUCKET_KEY.key(), s3BucketKey);
        return new LogicalWriteInfo(){

            public String queryId() {
                return defaultInfo.queryId();
            }

            public StructType schema() {
                return defaultInfo.schema();
            }

            public CaseInsensitiveStringMap options() {
                return new CaseInsensitiveStringMap(map);
            }
        };
    }

    private List<String> getS3WritePath(String path) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(Arrays.asList(path).iterator()).asScala()).toList();
    }
}

