/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.s3;

import com.exasol.spark.common.ExasolOptions;
import com.exasol.spark.s3.S3FileSystem;
import java.util.logging.Logger;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerJobEnd;

public final class S3CleanupListener
extends SparkListener {
    private static final Logger LOGGER = Logger.getLogger(S3CleanupListener.class.getName());
    private final ExasolOptions options;
    private final String bucketKey;

    public S3CleanupListener(ExasolOptions options, String bucketKey) {
        this.options = options;
        this.bucketKey = bucketKey;
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        LOGGER.info(() -> "Cleaning up the bucket '" + this.options.getS3Bucket() + "' with key '" + this.bucketKey + "' in job '" + jobEnd.jobId() + "'.");
        this.deleteObjects();
        super.onJobEnd(jobEnd);
    }

    private void deleteObjects() {
        try (S3FileSystem s3FileSystem = S3FileSystem.fromOptions(this.options);){
            s3FileSystem.deleteKeys(this.options.getS3Bucket(), this.bucketKey);
        }
    }
}

