/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.s3;

import com.exasol.spark.common.ExasolOptions;
import com.exasol.spark.common.Option;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

public final class S3ClientFactory {
    private final ExasolOptions options;

    public S3ClientFactory(ExasolOptions options) {
        this.options = options;
    }

    public S3Client getS3Client() {
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().credentialsProvider(this.getCredentialsProvider());
        this.setRegionIfEnabled((S3BaseClientBuilder<?, ?>)builder);
        this.setPathStyleAccessIfEnabled((S3BaseClientBuilder<?, ?>)builder);
        this.setEndpointOverrideIfEnabled((S3BaseClientBuilder<?, ?>)builder);
        return (S3Client)builder.build();
    }

    private void setRegionIfEnabled(S3BaseClientBuilder<?, ?> builder) {
        if (this.options.containsKey(Option.AWS_REGION.key())) {
            builder.region(Region.of((String)this.options.get(Option.AWS_REGION.key())));
        }
    }

    private AwsCredentialsProvider getCredentialsProvider() {
        String awsAccessKeyId = this.options.get(Option.AWS_ACCESS_KEY_ID.key());
        String awsSecretAccessKey = this.options.get(Option.AWS_SECRET_ACCESS_KEY.key());
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)awsAccessKeyId, (String)awsSecretAccessKey));
    }

    private void setPathStyleAccessIfEnabled(S3BaseClientBuilder<?, ?> builder) {
        if (this.options.hasEnabled(Option.S3_PATH_STYLE_ACCESS.key())) {
            builder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
        }
    }

    private void setEndpointOverrideIfEnabled(S3BaseClientBuilder<?, ?> builder) {
        if (this.options.containsKey(Option.S3_ENDPOINT_OVERRIDE.key())) {
            builder.endpointOverride(URI.create(this.getEndpointOverride()));
        }
    }

    private String getEndpointOverride() {
        String protocol = this.getProtocol();
        return protocol + "://s3." + this.options.get(Option.S3_ENDPOINT_OVERRIDE.key());
    }

    private String getProtocol() {
        if (!this.options.containsKey(Option.AWS_USE_SSL.key()) || this.options.hasEnabled(Option.AWS_USE_SSL.key())) {
            return "https";
        }
        return "http";
    }
}

