/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.s3;

import com.exasol.errorreporting.ExaError;
import com.exasol.spark.common.ExasolOptions;
import com.exasol.spark.s3.ExasolConnectionException;
import com.exasol.spark.s3.S3ClientFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public final class S3FileSystem
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(S3FileSystem.class.getName());
    private final S3Client s3Client;

    public S3FileSystem(S3Client s3Client) {
        this.s3Client = s3Client;
    }

    public static S3FileSystem fromOptions(ExasolOptions options) {
        return new S3FileSystem(new S3ClientFactory(options).getS3Client());
    }

    public boolean doesBucketExist(String bucketName) {
        try {
            this.s3Client.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build());
            return true;
        }
        catch (NoSuchBucketException exception) {
            return false;
        }
    }

    public void deleteBucket(String bucketName) {
        LOGGER.info(() -> "Deleting S3 bucket '" + bucketName + "'.");
        this.deleteObjects(bucketName, Optional.empty());
    }

    public void deleteKeys(String bucketName, String bucketKey) {
        LOGGER.info(() -> "Deleting objects in S3 bucket '" + bucketName + "' with bucket key '" + bucketKey + "'.");
        this.deleteObjects(bucketName, Optional.of(bucketKey));
    }

    private void deleteObjects(String bucketName, Optional<String> bucketKey) {
        try {
            List<S3Object> objects = this.listObjects(bucketName, bucketKey);
            List<ObjectIdentifier> objectIdentifiers = objects.stream().map(object -> (ObjectIdentifier)ObjectIdentifier.builder().key(object.key()).build()).collect(Collectors.toList());
            this.deleteObjectIdentifiers(bucketName, objectIdentifiers);
        }
        catch (SdkClientException exception) {
            throw new ExasolConnectionException(ExaError.messageBuilder((String)"E-SEC-20").message("Failed to delete objects in {{BUCKET}} with key {{KEY}}.", new Object[]{bucketName, bucketKey.orElse("emptyBucketKey")}).mitigation("Please check that credentials and bucket name are correct.", new Object[0]).toString(), exception);
        }
        catch (S3Exception exception) {
            throw new ExasolConnectionException(ExaError.messageBuilder((String)"E-SEC-21").message("Failed to delete objects in {{BUCKET}} with key {{KEY}} because of unexpected S3 exception.", new Object[0]).parameter("BUCKET", (Object)bucketName).parameter("KEY", (Object)bucketKey.orElse("emptyBucketKey")).ticketMitigation().toString(), exception);
        }
    }

    public List<S3Object> listObjects(String bucketName, Optional<String> bucketKey) {
        ArrayList<S3Object> result = new ArrayList<S3Object>();
        ListObjectsV2Request.Builder builder = ListObjectsV2Request.builder().bucket(bucketName);
        if (bucketKey.isPresent()) {
            builder.prefix(bucketKey.get());
        }
        for (ListObjectsV2Response page : this.s3Client.listObjectsV2Paginator((ListObjectsV2Request)builder.build())) {
            for (S3Object s3Object : page.contents()) {
                result.add(s3Object);
            }
        }
        return result;
    }

    public boolean isEmpty(String bucketName, Optional<String> bucketKey) {
        ListObjectsV2Request.Builder builder = ListObjectsV2Request.builder().bucket(bucketName);
        if (bucketKey.isPresent()) {
            builder.prefix(bucketKey.get());
        }
        for (ListObjectsV2Response page : this.s3Client.listObjectsV2Paginator((ListObjectsV2Request)builder.build())) {
            if (page.contents().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void deleteObjectIdentifiers(String bucketName, List<ObjectIdentifier> objectIdentifiers) {
        if (!objectIdentifiers.isEmpty()) {
            DeleteObjectsRequest deleteObjectsRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(objectIdentifiers).build()).build();
            this.s3Client.deleteObjects(deleteObjectsRequest);
        }
    }

    @Override
    public void close() {
        this.s3Client.close();
    }
}

