/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.s3;

import com.exasol.errorreporting.ExaError;
import com.exasol.spark.common.ColumnDescription;
import com.exasol.spark.common.ExasolOptions;
import com.exasol.spark.common.Option;
import com.exasol.spark.common.SchemaConverter;
import com.exasol.spark.s3.ExasolConnectionException;
import com.exasol.spark.s3.ExasolConnectionFactory;
import com.exasol.spark.s3.ExasolS3Table;
import com.exasol.sql.StatementFactory;
import com.exasol.sql.dql.select.Select;
import com.exasol.sql.dql.select.SelectVisitor;
import com.exasol.sql.dql.select.rendering.SelectRenderer;
import com.exasol.sql.rendering.StringRendererConfig;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class S3Source
implements TableProvider,
DataSourceRegister {
    private static final Logger LOGGER = Logger.getLogger(S3Source.class.getName());
    private static final List<String> REQUIRED_OPTIONS = Arrays.asList(Option.HOST.key(), Option.PORT.key(), Option.USERNAME.key(), Option.PASSWORD.key());

    public String shortName() {
        return "exasol-s3";
    }

    public boolean supportsExternalMetadata() {
        return true;
    }

    public StructType inferSchema(CaseInsensitiveStringMap map) {
        LOGGER.fine(() -> "Running schema inference for the S3 source.");
        this.validateOptions(map);
        return this.getSchema(ExasolOptions.from((CaseInsensitiveStringMap)map));
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> properties) {
        return new ExasolS3Table(schema);
    }

    private void validateOptions(CaseInsensitiveStringMap options) {
        LOGGER.finest(() -> "Validating options of the s3 source.");
        if (!options.containsKey((Object)Option.TABLE.key()) && !options.containsKey((Object)Option.QUERY.key())) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-SEC-12").message("Missing 'query' or 'table' option.", new Object[0]).mitigation("Please provide either one of 'query' or 'table' options.", new Object[0]).toString());
        }
        if (options.containsKey((Object)Option.TABLE.key()) && options.containsKey((Object)Option.QUERY.key())) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-SEC-13").message("Both 'query' and 'table' options are provided.", new Object[0]).mitigation("Please use only either one of the options.", new Object[0]).toString());
        }
        this.validateRequiredOptions(options);
    }

    private void validateRequiredOptions(CaseInsensitiveStringMap options) {
        for (String key : REQUIRED_OPTIONS) {
            if (options.containsKey((Object)key)) continue;
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-SEC-14").message("Required option {{KEY}} is not found.", new Object[0]).mitigation("Please provide a value for the {{KEY}} option.", new Object[0]).parameter("KEY", (Object)key).toString());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private StructType getSchema(ExasolOptions options) {
        String limitQuery = this.generateInferSchemaQuery(options);
        LOGGER.info(() -> "Running schema inference using limited query '" + limitQuery + "' for the s3 source.");
        try (Connection connection = new ExasolConnectionFactory(options).getConnection();){
            StructType structType;
            block14: {
                Statement statement = connection.createStatement();
                try {
                    StructType schema = this.getSparkSchema(statement.executeQuery(limitQuery));
                    LOGGER.info(() -> "Inferred schema as '" + schema.toString() + "' for the s3 source.");
                    structType = schema;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return structType;
        }
        catch (SQLException exception) {
            throw new ExasolConnectionException(ExaError.messageBuilder((String)"E-SEC-15").message("Could not run the limit query {{limitQuery}} to infer the schema.", new Object[]{limitQuery}).mitigation("Please check that connection properties and original query are correct.", new Object[0]).toString(), exception);
        }
    }

    private String generateInferSchemaQuery(ExasolOptions options) {
        Select select = StatementFactory.getInstance().select();
        select.all().from().table("<SCHEMA_INFERENCE_TABLE>");
        if (options.hasQuery()) {
            select.limit(1);
        }
        StringRendererConfig rendererConfig = StringRendererConfig.builder().quoteIdentifiers(true).build();
        SelectRenderer renderer = new SelectRenderer(rendererConfig);
        select.accept((SelectVisitor)renderer);
        return renderer.render().replace("\"<SCHEMA_INFERENCE_TABLE>\"", this.getTableOrQuery(options));
    }

    private String getTableOrQuery(ExasolOptions options) {
        if (options.hasTable()) {
            return options.getTable();
        }
        return "(" + options.getQuery() + ")";
    }

    private StructType getSparkSchema(ResultSet resultSet) {
        try {
            ResultSetMetaData metadata = resultSet.getMetaData();
            int numberOfColumns = metadata.getColumnCount();
            ArrayList<ColumnDescription> columns = new ArrayList<ColumnDescription>(numberOfColumns);
            for (int i = 1; i <= numberOfColumns; ++i) {
                columns.add(ColumnDescription.builder().name(metadata.getColumnLabel(i)).type(metadata.getColumnType(i)).precision(metadata.getPrecision(i)).scale(metadata.getScale(i)).isSigned(metadata.isSigned(i)).isNullable(metadata.isNullable(i) != 0).build());
            }
            return new SchemaConverter().convert(columns);
        }
        catch (SQLException exception) {
            throw new ExasolConnectionException(ExaError.messageBuilder((String)"E-SEC-16").message("Could not create Spark schema from provided Exasol SQL query or table name.", new Object[0]).mitigation("Please make sure that Exasol SQL query or table have columns.", new Object[0]).toString(), exception);
        }
    }
}

