/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.adapternotes;

import com.exasol.adapter.AdapterException;
import com.exasol.adapter.adapternotes.ColumnAdapterNotes;
import com.exasol.utils.JsonHelper;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public final class ColumnAdapterNotesJsonConverter {
    private static final ColumnAdapterNotesJsonConverter COLUMN_ADAPTER_NOTES_JSON_CONVERTER = new ColumnAdapterNotesJsonConverter();

    public static ColumnAdapterNotesJsonConverter getInstance() {
        return COLUMN_ADAPTER_NOTES_JSON_CONVERTER;
    }

    private ColumnAdapterNotesJsonConverter() {
    }

    public String convertToJson(ColumnAdapterNotes columnAdapterNotes) {
        JsonBuilderFactory factory = JsonHelper.getBuilderFactory();
        JsonObjectBuilder builder = factory.createObjectBuilder().add("jdbcDataType", columnAdapterNotes.getJdbcDataType());
        return builder.build().toString();
    }

    public ColumnAdapterNotes convertFromJsonToColumnAdapterNotes(String adapterNotes, String columnName) throws AdapterException {
        JsonObject root;
        if (adapterNotes == null || adapterNotes.isEmpty()) {
            throw new AdapterException("Adapter notes for column " + columnName + " are empty or NULL. Please refresh the virtual schema.");
        }
        try {
            root = JsonHelper.getJsonObject((String)adapterNotes);
        }
        catch (Exception exception) {
            throw new AdapterException("Could not parse the column adapter notes of column \"" + columnName + "\".Please refresh the virtual schema.", exception);
        }
        return new ColumnAdapterNotes(root.getInt("jdbcDataType"));
    }
}

