/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.adapternotes;

import com.exasol.adapter.AdapterException;
import com.exasol.adapter.adapternotes.SchemaAdapterNotes;
import com.exasol.utils.JsonHelper;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public final class SchemaAdapterNotesJsonConverter {
    private static final String CATALOG_SEPARATOR = "catalogSeparator";
    private static final String IDENTIFIER_QUOTE_STRING = "identifierQuoteString";
    private static final String STORES_LOWER_CASE_IDENTIFIERS = "storesLowerCaseIdentifiers";
    private static final String STORES_UPPER_CASE_IDENTIFIERS = "storesUpperCaseIdentifiers";
    private static final String STORES_MIXED_CASE_IDENTIFIERS = "storesMixedCaseIdentifiers";
    private static final String SUPPORTS_MIXED_CASE_IDENTIFIERS = "supportsMixedCaseIdentifiers";
    private static final String STORES_LOWER_CASE_QUOTED_IDENTIFIERS = "storesLowerCaseQuotedIdentifiers";
    private static final String STORES_UPPER_CASE_QUOTED_IDENTIFIERS = "storesUpperCaseQuotedIdentifiers";
    private static final String STORES_MIXED_CASE_QUOTED_IDENTIFIERS = "storesMixedCaseQuotedIdentifiers";
    private static final String SUPPORTS_MIXED_CASE_QUOTED_IDENTIFIERS = "supportsMixedCaseQuotedIdentifiers";
    private static final String NULLS_ARE_SORTED_AT_END = "areNullsSortedAtEnd";
    private static final String NULLS_ARE_SORTED_AT_START = "areNullsSortedAtStart";
    private static final String NULLS_ARE_SORTED_HIGH = "areNullsSortedHigh";
    private static final String NULLS_ARE_SORTED_LOW = "areNullsSortedLow";
    private static final SchemaAdapterNotesJsonConverter SCHEMA_ADAPTER_NOTES_JSON_CONVERTER = new SchemaAdapterNotesJsonConverter();

    public static SchemaAdapterNotesJsonConverter getInstance() {
        return SCHEMA_ADAPTER_NOTES_JSON_CONVERTER;
    }

    private SchemaAdapterNotesJsonConverter() {
    }

    public String convertToJson(SchemaAdapterNotes schemaAdapterNotes) {
        JsonBuilderFactory factory = JsonHelper.getBuilderFactory();
        JsonObjectBuilder builder = factory.createObjectBuilder().add(CATALOG_SEPARATOR, schemaAdapterNotes.getCatalogSeparator()).add(IDENTIFIER_QUOTE_STRING, schemaAdapterNotes.getIdentifierQuoteString()).add(STORES_LOWER_CASE_IDENTIFIERS, schemaAdapterNotes.storesLowerCaseIdentifiers()).add(STORES_UPPER_CASE_IDENTIFIERS, schemaAdapterNotes.storesUpperCaseIdentifiers()).add(STORES_MIXED_CASE_IDENTIFIERS, schemaAdapterNotes.storesMixedCaseIdentifiers()).add(SUPPORTS_MIXED_CASE_IDENTIFIERS, schemaAdapterNotes.supportsMixedCaseIdentifiers()).add(STORES_LOWER_CASE_QUOTED_IDENTIFIERS, schemaAdapterNotes.storesLowerCaseQuotedIdentifiers()).add(STORES_UPPER_CASE_QUOTED_IDENTIFIERS, schemaAdapterNotes.storesUpperCaseQuotedIdentifiers()).add(STORES_MIXED_CASE_QUOTED_IDENTIFIERS, schemaAdapterNotes.storesMixedCaseQuotedIdentifiers()).add(SUPPORTS_MIXED_CASE_QUOTED_IDENTIFIERS, schemaAdapterNotes.supportsMixedCaseQuotedIdentifiers()).add(NULLS_ARE_SORTED_AT_END, schemaAdapterNotes.areNullsSortedAtEnd()).add(NULLS_ARE_SORTED_AT_START, schemaAdapterNotes.areNullsSortedAtStart()).add(NULLS_ARE_SORTED_HIGH, schemaAdapterNotes.areNullsSortedHigh()).add(NULLS_ARE_SORTED_LOW, schemaAdapterNotes.areNullsSortedLow());
        return builder.build().toString();
    }

    public SchemaAdapterNotes convertFromJsonToSchemaAdapterNotes(String adapterNotes, String schemaName) throws AdapterException {
        JsonObject root;
        if (adapterNotes == null || adapterNotes.isEmpty()) {
            throw new AdapterException("Adapter notes for virtual schema " + schemaName + " are empty or NULL. Please refresh the virtual schema.");
        }
        try {
            root = JsonHelper.getJsonObject((String)adapterNotes);
        }
        catch (Exception exception) {
            throw new AdapterException("Could not parse the schema adapter notes of virtual schema \"" + schemaName + "\". Please refresh the virtual schema.", exception);
        }
        SchemaAdapterNotesJsonConverter.checkKey(root, CATALOG_SEPARATOR, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, IDENTIFIER_QUOTE_STRING, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, STORES_LOWER_CASE_IDENTIFIERS, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, STORES_UPPER_CASE_IDENTIFIERS, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, STORES_MIXED_CASE_IDENTIFIERS, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, SUPPORTS_MIXED_CASE_IDENTIFIERS, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, STORES_LOWER_CASE_QUOTED_IDENTIFIERS, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, STORES_UPPER_CASE_QUOTED_IDENTIFIERS, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, STORES_MIXED_CASE_QUOTED_IDENTIFIERS, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, SUPPORTS_MIXED_CASE_QUOTED_IDENTIFIERS, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, NULLS_ARE_SORTED_AT_END, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, NULLS_ARE_SORTED_AT_START, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, NULLS_ARE_SORTED_HIGH, schemaName);
        SchemaAdapterNotesJsonConverter.checkKey(root, NULLS_ARE_SORTED_LOW, schemaName);
        return SchemaAdapterNotes.builder().catalogSeparator(root.getString(CATALOG_SEPARATOR)).identifierQuoteString(root.getString(IDENTIFIER_QUOTE_STRING)).storesLowerCaseIdentifiers(root.getBoolean(STORES_LOWER_CASE_IDENTIFIERS)).storesUpperCaseIdentifiers(root.getBoolean(STORES_UPPER_CASE_IDENTIFIERS)).storesMixedCaseIdentifiers(root.getBoolean(STORES_MIXED_CASE_IDENTIFIERS)).supportsMixedCaseIdentifiers(root.getBoolean(SUPPORTS_MIXED_CASE_IDENTIFIERS)).storesLowerCaseQuotedIdentifiers(root.getBoolean(STORES_LOWER_CASE_QUOTED_IDENTIFIERS)).storesUpperCaseQuotedIdentifiers(root.getBoolean(STORES_UPPER_CASE_QUOTED_IDENTIFIERS)).storesMixedCaseQuotedIdentifiers(root.getBoolean(STORES_MIXED_CASE_QUOTED_IDENTIFIERS)).supportsMixedCaseQuotedIdentifiers(root.getBoolean(SUPPORTS_MIXED_CASE_QUOTED_IDENTIFIERS)).areNullsSortedAtEnd(root.getBoolean(NULLS_ARE_SORTED_AT_END)).areNullsSortedAtStart(root.getBoolean(NULLS_ARE_SORTED_AT_START)).areNullsSortedHigh(root.getBoolean(NULLS_ARE_SORTED_HIGH)).areNullsSortedLow(root.getBoolean(NULLS_ARE_SORTED_LOW)).build();
    }

    private static void checkKey(JsonObject root, String key, String schemaName) throws AdapterException {
        if (!root.containsKey((Object)key)) {
            throw new AdapterException("Adapter notes of virtual schema " + schemaName + " don't have the key " + key + ". Please refresh the virtual schema");
        }
    }
}

