/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.dialects;

import com.exasol.ExaMetadata;
import com.exasol.adapter.AdapterException;
import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.dialects.PropertyValidationException;
import com.exasol.adapter.dialects.QueryRewriter;
import com.exasol.adapter.dialects.SqlDialect;
import com.exasol.adapter.dialects.SqlGenerationContext;
import com.exasol.adapter.dialects.SqlGenerationVisitor;
import com.exasol.adapter.jdbc.ConnectionFactory;
import com.exasol.adapter.jdbc.RemoteMetadataReader;
import com.exasol.adapter.metadata.SchemaMetadata;
import com.exasol.adapter.sql.AggregateFunction;
import com.exasol.adapter.sql.ScalarFunction;
import com.exasol.adapter.sql.SqlNodeVisitor;
import com.exasol.adapter.sql.SqlStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractSqlDialect
implements SqlDialect {
    protected Set<ScalarFunction> omitParenthesesMap = EnumSet.noneOf(ScalarFunction.class);
    protected AdapterProperties properties;
    protected final ConnectionFactory connectionFactory;
    private static final Pattern BOOLEAN_PROPERTY_VALUE_PATTERN = Pattern.compile("^TRUE$|^FALSE$", 2);
    private static final Logger LOGGER = Logger.getLogger(AbstractSqlDialect.class.getName());

    public AbstractSqlDialect(ConnectionFactory connectionFactory, AdapterProperties properties) {
        this.connectionFactory = connectionFactory;
        this.properties = properties;
    }

    protected abstract RemoteMetadataReader createRemoteMetadataReader();

    protected abstract QueryRewriter createQueryRewriter();

    @Override
    public String getTableCatalogAndSchemaSeparator() {
        return ".";
    }

    @Override
    public boolean omitParentheses(ScalarFunction function) {
        return this.omitParenthesesMap.contains(function);
    }

    @Override
    public SqlNodeVisitor<String> getSqlGenerationVisitor(SqlGenerationContext context) {
        return new SqlGenerationVisitor(this, context);
    }

    @Override
    public Map<ScalarFunction, String> getScalarFunctionAliases() {
        return new EnumMap<ScalarFunction, String>(ScalarFunction.class);
    }

    @Override
    public Map<AggregateFunction, String> getAggregateFunctionAliases() {
        EnumMap<AggregateFunction, String> aliases = new EnumMap<AggregateFunction, String>(AggregateFunction.class);
        aliases.put(AggregateFunction.GEO_INTERSECTION_AGGREGATE, "ST_INTERSECTION");
        aliases.put(AggregateFunction.GEO_UNION_AGGREGATE, "ST_UNION");
        return aliases;
    }

    @Override
    public Map<ScalarFunction, String> getBinaryInfixFunctionAliases() {
        EnumMap<ScalarFunction, String> aliases = new EnumMap<ScalarFunction, String>(ScalarFunction.class);
        aliases.put(ScalarFunction.ADD, "+");
        aliases.put(ScalarFunction.SUB, "-");
        aliases.put(ScalarFunction.MULT, "*");
        aliases.put(ScalarFunction.FLOAT_DIV, "/");
        return aliases;
    }

    @Override
    public Map<ScalarFunction, String> getPrefixFunctionAliases() {
        EnumMap<ScalarFunction, String> aliases = new EnumMap<ScalarFunction, String>(ScalarFunction.class);
        aliases.put(ScalarFunction.NEG, "-");
        return aliases;
    }

    @Override
    public String rewriteQuery(SqlStatement statement, ExaMetadata exaMetadata) throws AdapterException, SQLException {
        return this.createQueryRewriter().rewrite(statement, exaMetadata, this.properties);
    }

    @Override
    public SchemaMetadata readSchemaMetadata() throws SQLException {
        return this.createRemoteMetadataReader().readRemoteSchemaMetadata();
    }

    @Override
    public SchemaMetadata readSchemaMetadata(List<String> tables) {
        return this.createRemoteMetadataReader().readRemoteSchemaMetadata(tables);
    }

    @Override
    public String getStringLiteral(String value) {
        if (value == null) {
            return "NULL";
        }
        return "'" + value.replace("'", "''") + "'";
    }

    @Override
    public void validateProperties() throws PropertyValidationException {
        this.validateSupportedPropertiesList();
        this.validateConnectionProperties();
        this.validateCatalogNameProperty();
        this.validateSchemaNameProperty();
        this.validateDebugOutputAddress();
        this.validateExceptionHandling();
    }

    protected void validateSupportedPropertiesList() throws PropertyValidationException {
        ArrayList allProperties = new ArrayList(this.properties.keySet());
        for (String property : allProperties) {
            if (this.getSupportedProperties().contains(property)) continue;
            String unsupportedElement = property;
            throw new PropertyValidationException(this.createUnsupportedElementMessage(unsupportedElement, property));
        }
    }

    protected abstract List<String> getSupportedProperties();

    protected String createUnsupportedElementMessage(String unsupportedElement, String property) {
        return "The dialect " + this.properties.getSqlDialect() + " does not support " + unsupportedElement + " property. Please, do not set the " + property + " property.";
    }

    private void validateConnectionProperties() throws PropertyValidationException {
        if (this.properties.containsKey("CONNECTION_NAME")) {
            if (this.properties.containsKey("CONNECTION_STRING") || this.properties.containsKey("USERNAME") || this.properties.containsKey("PASSWORD")) {
                throw new PropertyValidationException("You specified a connection using the property CONNECTION_NAME and therefore should not specify the properties CONNECTION_STRING, USERNAME and PASSWORD");
            }
        } else if (!this.properties.containsKey("CONNECTION_STRING")) {
            throw new PropertyValidationException("You did not specify a connection using the property CONNECTION_NAME and therefore have to specify the property CONNECTION_STRING");
        }
    }

    private void validateCatalogNameProperty() throws PropertyValidationException {
        if (this.properties.containsKey("CATALOG_NAME") && this.supportsJdbcCatalogs() == SqlDialect.StructureElementSupport.NONE) {
            throw new PropertyValidationException(this.createUnsupportedElementMessage("catalogs", "CATALOG_NAME"));
        }
    }

    private void validateSchemaNameProperty() throws PropertyValidationException {
        if (this.properties.containsKey("SCHEMA_NAME") && this.supportsJdbcSchemas() == SqlDialect.StructureElementSupport.NONE) {
            throw new PropertyValidationException(this.createUnsupportedElementMessage("schemas", "SCHEMA_NAME"));
        }
    }

    protected void validateBooleanProperty(String property) throws PropertyValidationException {
        if (this.properties.containsKey(property) && !BOOLEAN_PROPERTY_VALUE_PATTERN.matcher(this.properties.get(property)).matches()) {
            throw new PropertyValidationException("The value '" + this.properties.get(property) + "' for the property " + property + " is invalid. It has to be either 'true' or 'false' (case insensitive).");
        }
    }

    private void validateDebugOutputAddress() {
        String debugAddress;
        if (this.properties.containsKey("DEBUG_ADDRESS") && !(debugAddress = this.properties.getDebugAddress()).isEmpty()) {
            this.validateDebugPortNumber(debugAddress);
        }
    }

    private void validateDebugPortNumber(String debugAddress) {
        int colonLocation = debugAddress.lastIndexOf(58);
        if (colonLocation > 0) {
            String portAsString = debugAddress.substring(colonLocation + 1);
            try {
                int port = Integer.parseInt(portAsString);
                if (port < 1 || port > 65535) {
                    LOGGER.warning(() -> "Debug output port " + port + " is out of range. Port specified in property DEBUG_ADDRESSmust have following format: <host>[:<port>], and be between 1 and 65535.");
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.warning(() -> "Illegal debug output port \"" + portAsString + "\". Property DEBUG_ADDRESSmust have following format: <host>[:<port>], where port is a number between 1 and 65535.");
            }
        }
    }

    private void validateExceptionHandling() throws PropertyValidationException {
        String exceptionHandling;
        if (this.properties.containsKey("EXCEPTION_HANDLING") && (exceptionHandling = this.properties.getExceptionHandling()) != null && !exceptionHandling.isEmpty()) {
            for (SqlDialect.ExceptionHandlingMode mode : SqlDialect.ExceptionHandlingMode.values()) {
                if (mode.name().equals(exceptionHandling)) continue;
                throw new PropertyValidationException("Invalid value '" + exceptionHandling + "' for property EXCEPTION_HANDLING. Choose one of: " + SqlDialect.ExceptionHandlingMode.IGNORE_INVALID_VIEWS.name() + ", " + SqlDialect.ExceptionHandlingMode.NONE.name());
            }
        }
    }

    protected void checkImportPropertyConsistency(String importFromProperty, String connectionProperty) throws PropertyValidationException {
        boolean connectionIsEmpty;
        boolean isDirectImport = this.properties.isEnabled(importFromProperty);
        String value = this.properties.get(connectionProperty);
        boolean bl = connectionIsEmpty = value == null || value.isEmpty();
        if (isDirectImport) {
            if (connectionIsEmpty) {
                throw new PropertyValidationException("You defined the property " + importFromProperty + ", please also define " + connectionProperty);
            }
        } else if (!connectionIsEmpty) {
            throw new PropertyValidationException("You defined the property " + connectionProperty + " without setting " + importFromProperty + " to 'TRUE'. This is not allowed");
        }
    }

    protected void validateCastNumberToDecimalProperty(String castNumberToDecimalProperty) throws PropertyValidationException {
        String precisionAndScale;
        Pattern pattern;
        Matcher matcher;
        if (this.properties.containsKey(castNumberToDecimalProperty) && !(matcher = (pattern = Pattern.compile("\\s*(\\d+)\\s*,\\s*(\\d+)\\s*")).matcher(precisionAndScale = this.properties.get(castNumberToDecimalProperty))).matches()) {
            throw new PropertyValidationException("Unable to parse adapter property " + castNumberToDecimalProperty + " value \"" + precisionAndScale + " into a number's precision and scale. The required format is \"<precision>.<scale>\", where both are integer numbers.");
        }
    }
}

