/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.dialects;

import com.exasol.ExaConnectionAccessException;
import com.exasol.ExaConnectionInformation;
import com.exasol.ExaMetadata;
import com.exasol.adapter.AdapterException;
import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.dialects.QueryRewriter;
import com.exasol.adapter.dialects.SqlDialect;
import com.exasol.adapter.dialects.SqlGenerationContext;
import com.exasol.adapter.jdbc.BaseConnectionDefinitionBuilder;
import com.exasol.adapter.jdbc.ColumnMetadataReader;
import com.exasol.adapter.jdbc.ConnectionDefinitionBuilder;
import com.exasol.adapter.jdbc.ConnectionFactory;
import com.exasol.adapter.jdbc.RemoteMetadataReader;
import com.exasol.adapter.jdbc.ResultSetMetadataReader;
import com.exasol.adapter.sql.SqlNodeVisitor;
import com.exasol.adapter.sql.SqlStatement;
import java.sql.SQLException;
import java.util.logging.Logger;

public class BaseQueryRewriter
implements QueryRewriter {
    private static final Logger LOGGER = Logger.getLogger(BaseQueryRewriter.class.getName());
    protected final SqlDialect dialect;
    protected final RemoteMetadataReader remoteMetadataReader;
    protected final ConnectionFactory connectionFactory;
    protected final ConnectionDefinitionBuilder connectionDefinitionBuilder;

    public BaseQueryRewriter(SqlDialect dialect, RemoteMetadataReader remoteMetadataReader, ConnectionFactory connectionFactory) {
        this.dialect = dialect;
        this.remoteMetadataReader = remoteMetadataReader;
        this.connectionFactory = connectionFactory;
        this.connectionDefinitionBuilder = this.createConnectionDefinitionBuilder();
    }

    protected ConnectionDefinitionBuilder createConnectionDefinitionBuilder() {
        return new BaseConnectionDefinitionBuilder();
    }

    @Override
    public String rewrite(SqlStatement statement, ExaMetadata exaMetadata, AdapterProperties properties) throws AdapterException, SQLException {
        String query = this.createPushdownQuery(statement, properties);
        String columnDescription = this.createImportColumnsDescription(query);
        ExaConnectionInformation exaConnectionInformation = this.getConnectionInformation(exaMetadata, properties);
        String connectionDefinition = this.connectionDefinitionBuilder.buildConnectionDefinition(properties, exaConnectionInformation);
        String importFromPushdownQuery = this.generatePushdownSql(columnDescription, connectionDefinition, query);
        LOGGER.finer(() -> "Import from push-down query:\n" + importFromPushdownQuery);
        return importFromPushdownQuery;
    }

    private String createPushdownQuery(SqlStatement statement, AdapterProperties properties) throws AdapterException {
        SqlGenerationContext context = new SqlGenerationContext(properties.getCatalogName(), properties.getSchemaName(), false);
        SqlNodeVisitor<String> sqlGeneratorVisitor = this.dialect.getSqlGenerationVisitor(context);
        String pushdownQuery = (String)statement.accept(sqlGeneratorVisitor);
        LOGGER.finer(() -> "Push-down query generated with " + sqlGeneratorVisitor.getClass().getSimpleName() + ":\n" + pushdownQuery);
        return pushdownQuery;
    }

    private String createImportColumnsDescription(String query) throws SQLException {
        ColumnMetadataReader columnMetadataReader = this.remoteMetadataReader.getColumnMetadataReader();
        ResultSetMetadataReader resultSetMetadataReader = new ResultSetMetadataReader(this.connectionFactory.getConnection(), columnMetadataReader);
        String columnsDescription = resultSetMetadataReader.describeColumns(query);
        LOGGER.finer(() -> "Import columns: " + columnsDescription);
        return columnsDescription;
    }

    protected ExaConnectionInformation getConnectionInformation(ExaMetadata exaMetadata, AdapterProperties properties) throws AdapterException {
        ExaConnectionInformation exaConnectionInformation;
        if (properties.hasConnectionName()) {
            String connectionName = properties.getConnectionName();
            try {
                exaConnectionInformation = exaMetadata.getConnection(connectionName);
            }
            catch (ExaConnectionAccessException exception) {
                throw new AdapterException("Unable to access information about the Exasol connection named \"" + connectionName + "\" trying to create a connection definition for rewritten query.", (Exception)((Object)exception));
            }
        } else {
            exaConnectionInformation = null;
        }
        return exaConnectionInformation;
    }

    private String generatePushdownSql(String columnDescription, String connectionDefinition, String pushdownSql) {
        return "IMPORT INTO (" + columnDescription + ") FROM JDBC " + connectionDefinition + " STATEMENT '" + pushdownSql.replace("'", "''") + "'";
    }
}

