/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.dialects;

import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.dialects.SqlDialect;
import com.exasol.adapter.dialects.SqlDialectFactory;
import com.exasol.adapter.jdbc.ConnectionFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class SqlDialectRegistry {
    private static final Logger LOGGER = Logger.getLogger(SqlDialectRegistry.class.getName());
    private static SqlDialectRegistry instance;
    private final Map<String, SqlDialectFactory> registeredFactories = new HashMap<String, SqlDialectFactory>();

    public static final synchronized SqlDialectRegistry getInstance() {
        if (instance == null) {
            LOGGER.finer(() -> "Instanciating SQL dialect registry and loading adapter factories.");
            instance = new SqlDialectRegistry();
            instance.loadSqlDialectFactories();
        }
        return instance;
    }

    private void loadSqlDialectFactories() {
        ServiceLoader<SqlDialectFactory> serviceLoader = ServiceLoader.load(SqlDialectFactory.class);
        for (SqlDialectFactory factory : serviceLoader) {
            this.registerSqlDialectFactory(factory);
        }
        LOGGER.fine(() -> "Registered SQL dialects: " + this.listRegisteredSqlDialectNames());
    }

    private void registerSqlDialectFactory(SqlDialectFactory factory) {
        this.registeredFactories.put(factory.getSqlDialectName(), factory);
    }

    public List<SqlDialectFactory> getRegisteredAdapterFactories() {
        return new ArrayList<SqlDialectFactory>(this.registeredFactories.values());
    }

    public Set<String> getRegisteredAdapterNames() {
        return this.registeredFactories.values().stream().map(SqlDialectFactory::getSqlDialectName).collect(Collectors.toSet());
    }

    public SqlDialect getDialectForName(String name, ConnectionFactory connectionFactory, AdapterProperties properties) {
        if (this.hasDialectWithName(name)) {
            SqlDialectFactory factory = this.registeredFactories.get(name);
            LOGGER.config(() -> "Loading SQL dialect: " + factory.getSqlDialectName() + " dialect adapter " + factory.getSqlDialectVersion());
            return factory.createSqlDialect(connectionFactory, properties);
        }
        throw new IllegalArgumentException("Unknown SQL dialect \"" + name + "\" requested. " + this.describe());
    }

    public boolean hasDialectWithName(String name) {
        return this.registeredFactories.containsKey(name);
    }

    public void clear() {
        this.registeredFactories.clear();
    }

    public String describe() {
        return "Currently registered SQL dialect factories: " + this.listRegisteredSqlDialectNames();
    }

    public String listRegisteredSqlDialectNames() {
        String dialectNamesAsString = this.registeredFactories.keySet().stream().sorted().map(name -> "\"" + name + "\"").collect(Collectors.joining(", "));
        return dialectNamesAsString.isEmpty() ? "none" : dialectNamesAsString;
    }
}

