/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.dialects;

import com.exasol.adapter.metadata.ColumnMetadata;
import com.exasol.adapter.metadata.TableMetadata;
import com.exasol.adapter.sql.SqlColumn;
import com.exasol.adapter.sql.SqlJoin;
import com.exasol.adapter.sql.SqlNode;
import com.exasol.adapter.sql.SqlNodeType;
import com.exasol.adapter.sql.SqlSelectList;
import com.exasol.adapter.sql.SqlStatementSelect;
import com.exasol.adapter.sql.SqlTable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class SqlGenerationHelper {
    private SqlGenerationHelper() {
    }

    public static boolean selectListRequiresCasts(SqlSelectList selectList, Predicate<SqlNode> nodeRequiresCast) {
        boolean requiresCasts = false;
        SqlStatementSelect select = (SqlStatementSelect)selectList.getParent();
        boolean columnId = false;
        ArrayList<TableMetadata> tableMetadata = new ArrayList<TableMetadata>();
        SqlGenerationHelper.addMetadata(select.getFromClause(), tableMetadata);
        for (TableMetadata tableMeta : tableMetadata) {
            for (ColumnMetadata columnMeta : tableMeta.getColumns()) {
                if (!nodeRequiresCast.test((SqlNode)new SqlColumn(0, columnMeta))) continue;
                requiresCasts = true;
            }
        }
        return requiresCasts;
    }

    public static void addMetadata(SqlNode node, List<TableMetadata> metadata) {
        if (node.getType() == SqlNodeType.TABLE) {
            SqlTable table = (SqlTable)node;
            metadata.add(table.getMetadata());
        } else if (node.getType() == SqlNodeType.JOIN) {
            SqlJoin join = (SqlJoin)node;
            SqlGenerationHelper.addMetadata(join.getLeft(), metadata);
            SqlGenerationHelper.addMetadata(join.getRight(), metadata);
        }
    }
}

