/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.dialects;

import com.exasol.adapter.AdapterException;
import com.exasol.adapter.dialects.SqlDialect;
import com.exasol.adapter.dialects.SqlGenerationContext;
import com.exasol.adapter.metadata.DataType;
import com.exasol.adapter.sql.AggregateFunction;
import com.exasol.adapter.sql.ScalarFunction;
import com.exasol.adapter.sql.SqlColumn;
import com.exasol.adapter.sql.SqlFunctionAggregate;
import com.exasol.adapter.sql.SqlFunctionAggregateGroupConcat;
import com.exasol.adapter.sql.SqlFunctionScalar;
import com.exasol.adapter.sql.SqlFunctionScalarCase;
import com.exasol.adapter.sql.SqlFunctionScalarCast;
import com.exasol.adapter.sql.SqlFunctionScalarExtract;
import com.exasol.adapter.sql.SqlGroupBy;
import com.exasol.adapter.sql.SqlJoin;
import com.exasol.adapter.sql.SqlLimit;
import com.exasol.adapter.sql.SqlLiteralBool;
import com.exasol.adapter.sql.SqlLiteralDate;
import com.exasol.adapter.sql.SqlLiteralDouble;
import com.exasol.adapter.sql.SqlLiteralExactnumeric;
import com.exasol.adapter.sql.SqlLiteralInterval;
import com.exasol.adapter.sql.SqlLiteralNull;
import com.exasol.adapter.sql.SqlLiteralString;
import com.exasol.adapter.sql.SqlLiteralTimestamp;
import com.exasol.adapter.sql.SqlLiteralTimestampUtc;
import com.exasol.adapter.sql.SqlNode;
import com.exasol.adapter.sql.SqlNodeType;
import com.exasol.adapter.sql.SqlNodeVisitor;
import com.exasol.adapter.sql.SqlOrderBy;
import com.exasol.adapter.sql.SqlPredicateAnd;
import com.exasol.adapter.sql.SqlPredicateBetween;
import com.exasol.adapter.sql.SqlPredicateEqual;
import com.exasol.adapter.sql.SqlPredicateInConstList;
import com.exasol.adapter.sql.SqlPredicateIsNotNull;
import com.exasol.adapter.sql.SqlPredicateIsNull;
import com.exasol.adapter.sql.SqlPredicateLess;
import com.exasol.adapter.sql.SqlPredicateLessEqual;
import com.exasol.adapter.sql.SqlPredicateLike;
import com.exasol.adapter.sql.SqlPredicateLikeRegexp;
import com.exasol.adapter.sql.SqlPredicateNot;
import com.exasol.adapter.sql.SqlPredicateNotEqual;
import com.exasol.adapter.sql.SqlPredicateOr;
import com.exasol.adapter.sql.SqlSelectList;
import com.exasol.adapter.sql.SqlStatementSelect;
import com.exasol.adapter.sql.SqlTable;
import java.util.ArrayList;
import java.util.List;

public class SqlGenerationVisitor
implements SqlNodeVisitor<String> {
    private final SqlDialect dialect;
    private final SqlGenerationContext context;

    public SqlGenerationVisitor(SqlDialect dialect, SqlGenerationContext context) {
        this.dialect = dialect;
        this.context = context;
        this.checkDialectAliases();
    }

    protected SqlDialect getDialect() {
        return this.dialect;
    }

    protected void checkDialectAliases() {
        for (ScalarFunction scalarFunction : this.dialect.getScalarFunctionAliases().keySet()) {
            if (scalarFunction.isSimple()) continue;
            throw new UnsupportedOperationException("The dialect " + this.dialect.getName() + " provided an alias for the non-simple scalar function " + scalarFunction.name() + ". This alias will never be considered.");
        }
        for (AggregateFunction aggregateFunction : this.dialect.getAggregateFunctionAliases().keySet()) {
            if (aggregateFunction.isSimple()) continue;
            throw new UnsupportedOperationException("The dialect " + this.dialect.getName() + " provided an alias for the non-simple aggregate function " + aggregateFunction.name() + ". This alias will never be considered.");
        }
    }

    protected boolean isDirectlyInSelectList(SqlColumn column) {
        return column.hasParent() && column.getParent().getType() == SqlNodeType.SELECT_LIST;
    }

    public String visit(SqlStatementSelect select) throws AdapterException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append((String)select.getSelectList().accept((SqlNodeVisitor)this));
        sql.append(" FROM ");
        sql.append((String)select.getFromClause().accept((SqlNodeVisitor)this));
        if (select.hasFilter()) {
            sql.append(" WHERE ");
            sql.append((String)select.getWhereClause().accept((SqlNodeVisitor)this));
        }
        if (select.hasGroupBy()) {
            sql.append(" GROUP BY ");
            sql.append((String)select.getGroupBy().accept((SqlNodeVisitor)this));
        }
        if (select.hasHaving()) {
            sql.append(" HAVING ");
            sql.append((String)select.getHaving().accept((SqlNodeVisitor)this));
        }
        if (select.hasOrderBy()) {
            sql.append(" ");
            sql.append((String)select.getOrderBy().accept((SqlNodeVisitor)this));
        }
        if (select.hasLimit()) {
            sql.append(" ");
            sql.append((String)select.getLimit().accept((SqlNodeVisitor)this));
        }
        return sql.toString();
    }

    public String visit(SqlSelectList selectList) throws AdapterException {
        if (selectList.isRequestAnyColumn()) {
            return this.representAnyColumnInSelectList();
        }
        if (selectList.isSelectStar()) {
            return this.representAsteriskInSelectList(selectList);
        }
        return this.createExplicitColumnsSelectList(selectList);
    }

    protected String representAnyColumnInSelectList() {
        return "true";
    }

    protected String representAsteriskInSelectList(SqlSelectList selectList) throws AdapterException {
        return "*";
    }

    protected String createExplicitColumnsSelectList(SqlSelectList selectList) throws AdapterException {
        List expressions = selectList.getExpressions();
        ArrayList<String> selectElement = new ArrayList<String>(expressions.size());
        for (SqlNode node : expressions) {
            selectElement.add((String)node.accept((SqlNodeVisitor)this));
        }
        return String.join((CharSequence)", ", selectElement);
    }

    public String visit(SqlColumn column) throws AdapterException {
        Object tablePrefix = "";
        if (column.hasTableAlias()) {
            tablePrefix = this.dialect.applyQuote(column.getTableAlias()) + this.dialect.getTableCatalogAndSchemaSeparator();
        } else if (column.getTableName() != null && !column.getTableName().isEmpty()) {
            tablePrefix = this.dialect.applyQuote(column.getTableName()) + this.dialect.getTableCatalogAndSchemaSeparator();
        }
        return (String)tablePrefix + this.dialect.applyQuote(column.getName());
    }

    public String visit(SqlTable table) {
        Object schemaPrefix = "";
        if (this.dialect.requiresCatalogQualifiedTableNames(this.context) && this.context.getCatalogName() != null && !this.context.getCatalogName().isEmpty()) {
            schemaPrefix = this.dialect.applyQuote(this.context.getCatalogName()) + this.dialect.getTableCatalogAndSchemaSeparator();
        }
        if (this.dialect.requiresSchemaQualifiedTableNames(this.context) && this.context.getSchemaName() != null && !this.context.getSchemaName().isEmpty()) {
            schemaPrefix = (String)schemaPrefix + this.dialect.applyQuote(this.context.getSchemaName()) + this.dialect.getTableCatalogAndSchemaSeparator();
        }
        if (table.hasAlias()) {
            return (String)schemaPrefix + this.dialect.applyQuote(table.getName()) + " " + this.dialect.applyQuote(table.getAlias());
        }
        return (String)schemaPrefix + this.dialect.applyQuote(table.getName());
    }

    public String visit(SqlJoin join) throws AdapterException {
        return (String)join.getLeft().accept((SqlNodeVisitor)this) + " " + join.getJoinType().name().replace('_', ' ') + " JOIN " + (String)join.getRight().accept((SqlNodeVisitor)this) + " ON " + (String)join.getCondition().accept((SqlNodeVisitor)this);
    }

    public String visit(SqlGroupBy groupBy) throws AdapterException {
        if (groupBy.getExpressions() == null || groupBy.getExpressions().isEmpty()) {
            throw new IllegalStateException("Unexpected internal state (empty group by)");
        }
        ArrayList<String> selectElement = new ArrayList<String>();
        for (SqlNode node : groupBy.getExpressions()) {
            selectElement.add((String)node.accept((SqlNodeVisitor)this));
        }
        return String.join((CharSequence)", ", selectElement);
    }

    public String visit(SqlFunctionAggregate function) throws AdapterException {
        ArrayList<String> argumentsSql = new ArrayList<String>();
        for (SqlNode node : function.getArguments()) {
            argumentsSql.add((String)node.accept((SqlNodeVisitor)this));
        }
        if (function.getFunctionName().equalsIgnoreCase("count") && argumentsSql.isEmpty()) {
            argumentsSql.add("*");
        }
        String distinctSql = "";
        if (function.hasDistinct()) {
            distinctSql = "DISTINCT ";
        }
        String functionNameInSourceSystem = function.getFunctionName();
        if (this.dialect.getAggregateFunctionAliases().containsKey(function.getFunction())) {
            functionNameInSourceSystem = this.dialect.getAggregateFunctionAliases().get(function.getFunction());
        }
        return functionNameInSourceSystem + "(" + distinctSql + String.join((CharSequence)", ", argumentsSql) + ")";
    }

    public String visit(SqlFunctionAggregateGroupConcat function) throws AdapterException {
        this.validateSingleAgrumentFunctionParameter(function);
        StringBuilder builder = new StringBuilder();
        builder.append(function.getFunctionName());
        builder.append("(");
        if (function.hasDistinct()) {
            builder.append("DISTINCT ");
        }
        builder.append((String)((SqlNode)function.getArguments().get(0)).accept((SqlNodeVisitor)this));
        if (function.hasOrderBy()) {
            builder.append(" ");
            String orderByString = (String)function.getOrderBy().accept((SqlNodeVisitor)this);
            builder.append(orderByString);
        }
        if (function.getSeparator() != null) {
            builder.append(" SEPARATOR ");
            builder.append("'");
            builder.append(function.getSeparator());
            builder.append("'");
        }
        builder.append(")");
        return builder.toString();
    }

    private void validateSingleAgrumentFunctionParameter(SqlFunctionAggregateGroupConcat function) {
        if (function.getArguments().size() != 1 || function.getArguments().get(0) == null) {
            throw new IllegalArgumentException("Function AGGREGATE GROUP CONCAT must have exactly one non-NULL parameter.");
        }
    }

    public String visit(SqlFunctionScalar function) throws AdapterException {
        ArrayList<String> argumentsSql = new ArrayList<String>();
        for (SqlNode node : function.getArguments()) {
            argumentsSql.add((String)node.accept((SqlNodeVisitor)this));
        }
        String functionNameInSourceSystem = function.getFunctionName();
        if (this.dialect.getScalarFunctionAliases().containsKey(function.getFunction())) {
            functionNameInSourceSystem = this.dialect.getScalarFunctionAliases().get(function.getFunction());
        } else {
            String realFunctionName;
            if (this.dialect.getBinaryInfixFunctionAliases().containsKey(function.getFunction())) {
                assert (argumentsSql.size() == 2);
                realFunctionName = function.getFunctionName();
                if (this.dialect.getBinaryInfixFunctionAliases().containsKey(function.getFunction())) {
                    realFunctionName = this.dialect.getBinaryInfixFunctionAliases().get(function.getFunction());
                }
                return "(" + (String)argumentsSql.get(0) + " " + realFunctionName + " " + (String)argumentsSql.get(1) + ")";
            }
            if (this.dialect.getPrefixFunctionAliases().containsKey(function.getFunction())) {
                assert (argumentsSql.size() == 1);
                realFunctionName = function.getFunctionName();
                if (this.dialect.getPrefixFunctionAliases().containsKey(function.getFunction())) {
                    realFunctionName = this.dialect.getPrefixFunctionAliases().get(function.getFunction());
                }
                return "(" + realFunctionName + (String)argumentsSql.get(0) + ")";
            }
        }
        if (argumentsSql.isEmpty() && this.dialect.omitParentheses(function.getFunction())) {
            return functionNameInSourceSystem;
        }
        return functionNameInSourceSystem + "(" + String.join((CharSequence)", ", argumentsSql) + ")";
    }

    public String visit(SqlFunctionScalarCase function) throws AdapterException {
        StringBuilder builder = new StringBuilder();
        builder.append("CASE");
        if (function.getBasis() != null) {
            builder.append(" ");
            builder.append((String)function.getBasis().accept((SqlNodeVisitor)this));
        }
        for (int i = 0; i < function.getArguments().size(); ++i) {
            SqlNode node = (SqlNode)function.getArguments().get(i);
            SqlNode result = (SqlNode)function.getResults().get(i);
            builder.append(" WHEN ");
            builder.append((String)node.accept((SqlNodeVisitor)this));
            builder.append(" THEN ");
            builder.append((String)result.accept((SqlNodeVisitor)this));
        }
        if (function.getResults().size() > function.getArguments().size()) {
            builder.append(" ELSE ");
            builder.append((String)((SqlNode)function.getResults().get(function.getResults().size() - 1)).accept((SqlNodeVisitor)this));
        }
        builder.append(" END");
        return builder.toString();
    }

    public String visit(SqlFunctionScalarCast function) throws AdapterException {
        this.validateSingleAgrumentFunctionParameter(function);
        StringBuilder builder = new StringBuilder();
        builder.append("CAST");
        builder.append("(");
        builder.append((String)((SqlNode)function.getArguments().get(0)).accept((SqlNodeVisitor)this));
        builder.append(" AS ");
        builder.append(function.getDataType());
        builder.append(")");
        return builder.toString();
    }

    private void validateSingleAgrumentFunctionParameter(SqlFunctionScalarCast function) {
        if (function.getArguments().size() != 1 || function.getArguments().get(0) == null) {
            throw new IllegalArgumentException("Function CAST must have exactly one non-NULL parameter.");
        }
    }

    public String visit(SqlFunctionScalarExtract function) throws AdapterException {
        this.validateSingleAgrumentFunctionParameter(function);
        String expression = (String)((SqlNode)function.getArguments().get(0)).accept((SqlNodeVisitor)this);
        return function.getFunctionName() + "(" + function.getToExtract() + " FROM " + expression + ")";
    }

    private void validateSingleAgrumentFunctionParameter(SqlFunctionScalarExtract function) {
        if (function.getArguments().size() != 1 || function.getArguments().get(0) == null) {
            throw new IllegalArgumentException("Function EXTRACT must have exactly one non-NULL parameter.");
        }
    }

    public String visit(SqlLimit limit) {
        Object offsetSql = "";
        if (limit.getOffset() != 0) {
            offsetSql = " OFFSET " + limit.getOffset();
        }
        return "LIMIT " + limit.getLimit() + (String)offsetSql;
    }

    public String visit(SqlLiteralBool literal) {
        if (literal.getValue()) {
            return "true";
        }
        return "false";
    }

    public String visit(SqlLiteralDate literal) {
        return "DATE '" + literal.getValue() + "'";
    }

    public String visit(SqlLiteralDouble literal) {
        return Double.toString(literal.getValue());
    }

    public String visit(SqlLiteralExactnumeric literal) {
        return literal.getValue().toString();
    }

    public String visit(SqlLiteralNull literal) {
        return "NULL";
    }

    public String visit(SqlLiteralString literal) {
        return this.dialect.getStringLiteral(literal.getValue());
    }

    public String visit(SqlLiteralTimestamp literal) {
        return "TIMESTAMP '" + literal.getValue() + "'";
    }

    public String visit(SqlLiteralTimestampUtc literal) {
        return "TIMESTAMP '" + literal.getValue() + "'";
    }

    public String visit(SqlLiteralInterval literal) {
        if (literal.getDataType().getIntervalType() == DataType.IntervalType.YEAR_TO_MONTH) {
            return "INTERVAL '" + literal.getValue() + "' YEAR (" + literal.getDataType().getPrecision() + ") TO MONTH";
        }
        return "INTERVAL '" + literal.getValue() + "' DAY (" + literal.getDataType().getPrecision() + ") TO SECOND (" + literal.getDataType().getIntervalFraction() + ")";
    }

    public String visit(SqlOrderBy orderBy) throws AdapterException {
        ArrayList<Object> sqlOrderElement = new ArrayList<Object>();
        for (int i = 0; i < orderBy.getExpressions().size(); ++i) {
            Object elementSql = (String)((SqlNode)orderBy.getExpressions().get(i)).accept((SqlNodeVisitor)this);
            boolean shallNullsBeAtTheEnd = (Boolean)orderBy.nullsLast().get(i);
            boolean isAscending = (Boolean)orderBy.isAscending().get(i);
            if (!isAscending) {
                elementSql = (String)elementSql + " DESC";
            }
            if (shallNullsBeAtTheEnd != this.nullsAreAtEndByDefault(isAscending, this.dialect.getDefaultNullSorting())) {
                elementSql = (String)elementSql + (shallNullsBeAtTheEnd ? " NULLS LAST" : " NULLS FIRST");
            }
            sqlOrderElement.add(elementSql);
        }
        return "ORDER BY " + String.join((CharSequence)", ", sqlOrderElement);
    }

    private boolean nullsAreAtEndByDefault(boolean isAscending, SqlDialect.NullSorting defaultNullSorting) {
        if (defaultNullSorting == SqlDialect.NullSorting.NULLS_SORTED_AT_END) {
            return true;
        }
        if (defaultNullSorting == SqlDialect.NullSorting.NULLS_SORTED_AT_START) {
            return false;
        }
        if (isAscending) {
            return defaultNullSorting == SqlDialect.NullSorting.NULLS_SORTED_HIGH;
        }
        return defaultNullSorting != SqlDialect.NullSorting.NULLS_SORTED_HIGH;
    }

    public String visit(SqlPredicateAnd predicate) throws AdapterException {
        ArrayList<String> operandsSql = new ArrayList<String>();
        for (SqlNode node : predicate.getAndedPredicates()) {
            operandsSql.add((String)node.accept((SqlNodeVisitor)this));
        }
        return "(" + String.join((CharSequence)" AND ", operandsSql) + ")";
    }

    public String visit(SqlPredicateBetween predicate) throws AdapterException {
        return (String)predicate.getExpression().accept((SqlNodeVisitor)this) + " BETWEEN " + (String)predicate.getBetweenLeft().accept((SqlNodeVisitor)this) + " AND " + (String)predicate.getBetweenRight().accept((SqlNodeVisitor)this);
    }

    public String visit(SqlPredicateEqual predicate) throws AdapterException {
        return (String)predicate.getLeft().accept((SqlNodeVisitor)this) + " = " + (String)predicate.getRight().accept((SqlNodeVisitor)this);
    }

    public String visit(SqlPredicateInConstList predicate) throws AdapterException {
        ArrayList<String> argumentsSql = new ArrayList<String>();
        for (SqlNode node : predicate.getInArguments()) {
            argumentsSql.add((String)node.accept((SqlNodeVisitor)this));
        }
        return (String)predicate.getExpression().accept((SqlNodeVisitor)this) + " IN (" + String.join((CharSequence)", ", argumentsSql) + ")";
    }

    public String visit(SqlPredicateLess predicate) throws AdapterException {
        return (String)predicate.getLeft().accept((SqlNodeVisitor)this) + " < " + (String)predicate.getRight().accept((SqlNodeVisitor)this);
    }

    public String visit(SqlPredicateLessEqual predicate) throws AdapterException {
        return (String)predicate.getLeft().accept((SqlNodeVisitor)this) + " <= " + (String)predicate.getRight().accept((SqlNodeVisitor)this);
    }

    public String visit(SqlPredicateLike predicate) throws AdapterException {
        String sql = (String)predicate.getLeft().accept((SqlNodeVisitor)this) + " LIKE " + (String)predicate.getPattern().accept((SqlNodeVisitor)this);
        if (predicate.getEscapeChar() != null) {
            sql = sql + " ESCAPE " + (String)predicate.getEscapeChar().accept((SqlNodeVisitor)this);
        }
        return sql;
    }

    public String visit(SqlPredicateLikeRegexp predicate) throws AdapterException {
        return (String)predicate.getLeft().accept((SqlNodeVisitor)this) + " REGEXP_LIKE " + (String)predicate.getPattern().accept((SqlNodeVisitor)this);
    }

    public String visit(SqlPredicateNot predicate) throws AdapterException {
        return "NOT (" + (String)predicate.getExpression().accept((SqlNodeVisitor)this) + ")";
    }

    public String visit(SqlPredicateNotEqual predicate) throws AdapterException {
        return (String)predicate.getLeft().accept((SqlNodeVisitor)this) + " <> " + (String)predicate.getRight().accept((SqlNodeVisitor)this);
    }

    public String visit(SqlPredicateOr predicate) throws AdapterException {
        ArrayList<String> operandsSql = new ArrayList<String>();
        for (SqlNode node : predicate.getOrPredicates()) {
            operandsSql.add((String)node.accept((SqlNodeVisitor)this));
        }
        return "(" + String.join((CharSequence)" OR ", operandsSql) + ")";
    }

    public String visit(SqlPredicateIsNull predicate) throws AdapterException {
        return (String)predicate.getExpression().accept((SqlNodeVisitor)this) + " IS NULL";
    }

    public String visit(SqlPredicateIsNotNull predicate) throws AdapterException {
        return (String)predicate.getExpression().accept((SqlNodeVisitor)this) + " IS NOT NULL";
    }
}

