/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.jdbc;

import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.adapternotes.SchemaAdapterNotes;
import com.exasol.adapter.adapternotes.SchemaAdapterNotesJsonConverter;
import com.exasol.adapter.dialects.IdentifierConverter;
import com.exasol.adapter.jdbc.AbstractMetadataReader;
import com.exasol.adapter.jdbc.ColumnMetadataReader;
import com.exasol.adapter.jdbc.RemoteMetadataReader;
import com.exasol.adapter.jdbc.RemoteMetadataReaderConstants;
import com.exasol.adapter.jdbc.RemoteMetadataReaderException;
import com.exasol.adapter.jdbc.TableMetadataReader;
import com.exasol.adapter.metadata.SchemaMetadata;
import com.exasol.adapter.metadata.TableMetadata;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

public abstract class AbstractRemoteMetadataReader
extends AbstractMetadataReader
implements RemoteMetadataReader {
    private static final Logger LOGGER = Logger.getLogger(AbstractRemoteMetadataReader.class.getName());
    protected final ColumnMetadataReader columnMetadataReader;
    protected final TableMetadataReader tableMetadataReader;
    protected final IdentifierConverter identifierConverter = this.createIdentifierConverter();

    public AbstractRemoteMetadataReader(Connection connection, AdapterProperties properties) {
        super(connection, properties);
        this.columnMetadataReader = this.createColumnMetadataReader();
        this.tableMetadataReader = this.createTableMetadataReader();
    }

    protected abstract ColumnMetadataReader createColumnMetadataReader();

    protected abstract TableMetadataReader createTableMetadataReader();

    protected abstract IdentifierConverter createIdentifierConverter();

    @Override
    public final ColumnMetadataReader getColumnMetadataReader() {
        return this.columnMetadataReader;
    }

    @Override
    public final TableMetadataReader getTableMetadataReader() {
        return this.tableMetadataReader;
    }

    public IdentifierConverter getIdentifierConverter() {
        return this.identifierConverter;
    }

    @Override
    public SchemaMetadata readRemoteSchemaMetadata() {
        try {
            String adapterNotes = SchemaAdapterNotesJsonConverter.getInstance().convertToJson(this.getSchemaAdapterNotes());
            DatabaseMetaData remoteMetadata = this.connection.getMetaData();
            List<TableMetadata> tables = this.extractTableMetadata(remoteMetadata, Optional.empty());
            return new SchemaMetadata(adapterNotes, tables);
        }
        catch (SQLException exception) {
            throw new RemoteMetadataReaderException("Unable to read remote schema metadata. SQL error: " + exception.getMessage(), exception);
        }
    }

    private List<TableMetadata> extractTableMetadata(DatabaseMetaData remoteMetadata, Optional<List<String>> selectedTables) throws SQLException {
        String catalogName = this.getCatalogNameFilter();
        String schemaName = this.getSchemaNameFilter();
        this.logTablesScan(catalogName, schemaName);
        try (ResultSet remoteTables = remoteMetadata.getTables(catalogName, schemaName, "%", this.getTableTypeFilter());){
            List<TableMetadata> list = this.tableMetadataReader.mapTables(remoteTables, selectedTables);
            return list;
        }
    }

    protected String[] getTableTypeFilter() {
        Set<String> supportedTableTypes = this.getSupportedTableTypes();
        return supportedTableTypes == null || supportedTableTypes.isEmpty() ? null : supportedTableTypes.toArray(new String[0]);
    }

    @Override
    public Set<String> getSupportedTableTypes() {
        return RemoteMetadataReaderConstants.DEFAULT_SUPPORTED_TABLE_TYPES;
    }

    protected void logTablesScan(String catalogName, String schemaName) {
        LOGGER.fine(() -> {
            StringBuilder builder = new StringBuilder("Scanning ");
            if (catalogName == null) {
                builder.append("any catalog, ");
            } else {
                builder.append("catalog \"");
                builder.append(catalogName);
                builder.append("\", ");
            }
            if (schemaName == null) {
                builder.append("any schema ");
            } else {
                builder.append("schema \"");
                builder.append(schemaName);
                builder.append("\" ");
            }
            builder.append("for contained tables of the following supported types: ");
            builder.append(String.join((CharSequence)", ", this.getSupportedTableTypes()));
            return builder.toString();
        });
    }

    @Override
    public SchemaAdapterNotes getSchemaAdapterNotes() {
        try {
            DatabaseMetaData metadata = this.connection.getMetaData();
            return SchemaAdapterNotes.builder().catalogSeparator(metadata.getCatalogSeparator()).identifierQuoteString(metadata.getIdentifierQuoteString()).storesLowerCaseIdentifiers(metadata.storesLowerCaseIdentifiers()).storesUpperCaseIdentifiers(metadata.storesUpperCaseIdentifiers()).storesMixedCaseIdentifiers(metadata.storesMixedCaseIdentifiers()).supportsMixedCaseIdentifiers(metadata.supportsMixedCaseIdentifiers()).storesLowerCaseQuotedIdentifiers(metadata.storesLowerCaseQuotedIdentifiers()).storesUpperCaseQuotedIdentifiers(metadata.storesUpperCaseQuotedIdentifiers()).storesMixedCaseQuotedIdentifiers(metadata.storesMixedCaseQuotedIdentifiers()).supportsMixedCaseQuotedIdentifiers(metadata.supportsMixedCaseQuotedIdentifiers()).areNullsSortedAtEnd(metadata.nullsAreSortedAtEnd()).areNullsSortedAtStart(metadata.nullsAreSortedAtStart()).areNullsSortedHigh(metadata.nullsAreSortedHigh()).areNullsSortedLow(metadata.nullsAreSortedLow()).build();
        }
        catch (SQLException exception) {
            throw new RemoteMetadataReaderException("Unable to create schema adapter notes from remote schema.", exception);
        }
    }

    @Override
    public SchemaMetadata readRemoteSchemaMetadata(List<String> selectedTables) {
        try {
            DatabaseMetaData remoteMetadata = this.connection.getMetaData();
            String adapterNotes = SchemaAdapterNotesJsonConverter.getInstance().convertToJson(this.getSchemaAdapterNotes());
            List<TableMetadata> tables = this.extractTableMetadata(remoteMetadata, this.convertToOptional(selectedTables));
            return new SchemaMetadata(adapterNotes, tables);
        }
        catch (SQLException exception) {
            throw new RemoteMetadataReaderException("Unable to read remote schema metadata.", exception);
        }
    }

    protected Optional<List<String>> convertToOptional(List<String> selectedTables) {
        if (selectedTables != null && !selectedTables.isEmpty()) {
            return Optional.of(selectedTables);
        }
        return Optional.empty();
    }
}

