/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.jdbc;

import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.adapternotes.ColumnAdapterNotes;
import com.exasol.adapter.adapternotes.ColumnAdapterNotesJsonConverter;
import com.exasol.adapter.dialects.IdentifierConverter;
import com.exasol.adapter.jdbc.AbstractMetadataReader;
import com.exasol.adapter.jdbc.ColumnMetadataReader;
import com.exasol.adapter.jdbc.JdbcTypeDescription;
import com.exasol.adapter.jdbc.RemoteMetadataReaderException;
import com.exasol.adapter.metadata.ColumnMetadata;
import com.exasol.adapter.metadata.DataType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseColumnMetadataReader
extends AbstractMetadataReader
implements ColumnMetadataReader {
    public static final Logger LOGGER = Logger.getLogger(BaseColumnMetadataReader.class.getName());
    public static final String NAME_COLUMN = "COLUMN_NAME";
    public static final String DATA_TYPE_COLUMN = "DATA_TYPE";
    public static final String SIZE_COLUMN = "COLUMN_SIZE";
    public static final String SCALE_COLUMN = "DECIMAL_DIGITS";
    public static final String CHAR_OCTET_LENGTH_COLUMN = "CHAR_OCTET_LENGTH";
    public static final String TYPE_NAME_COLUMN = "TYPE_NAME";
    public static final String REMARKS_COLUMN = "REMARKS";
    public static final String DEFAULT_VALUE_COLUMN = "COLUMN_DEF";
    public static final String AUTOINCREMENT_COLUMN = "IS_AUTOINCREMENT";
    public static final String NULLABLE_COLUMN = "IS_NULLABLE";
    private static final boolean DEFAULT_NULLABLE = true;
    private final IdentifierConverter identifierConverter;

    public BaseColumnMetadataReader(Connection connection, AdapterProperties properties, IdentifierConverter identifierConverter) {
        super(connection, properties);
        this.identifierConverter = identifierConverter;
    }

    @Override
    public List<ColumnMetadata> mapColumns(String tableName) {
        return this.mapColumns(this.getCatalogNameFilter(), this.getSchemaNameFilter(), tableName);
    }

    protected List<ColumnMetadata> mapColumns(String catalogName, String schemaName, String tableName) {
        List<ColumnMetadata> list;
        block8: {
            ResultSet remoteColumns = this.connection.getMetaData().getColumns(catalogName, schemaName, tableName, "%");
            try {
                list = this.getColumnsFromResultSet(remoteColumns);
                if (remoteColumns == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (remoteColumns != null) {
                        try {
                            remoteColumns.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    throw new RemoteMetadataReaderException("Unable to read column metadata from remote for catalog \"" + catalogName + "\" and schema \"" + schemaName + "\"", exception);
                }
            }
            remoteColumns.close();
        }
        return list;
    }

    protected List<ColumnMetadata> getColumnsFromResultSet(ResultSet remoteColumns) throws SQLException {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        while (remoteColumns.next()) {
            this.mapOrSkipColumn(remoteColumns, columns);
        }
        return columns;
    }

    public void mapOrSkipColumn(ResultSet remoteColumns, List<ColumnMetadata> columns) throws SQLException {
        ColumnMetadata metadata = this.mapColumn(remoteColumns);
        if (metadata.getType().isSupported()) {
            columns.add(metadata);
        } else {
            LOGGER.fine(() -> "Column \"" + metadata.getName() + "\" of type \"" + metadata.getOriginalTypeName() + "\" not supported by Virtual Schema. Skipping column in mapping.");
        }
    }

    private ColumnMetadata mapColumn(ResultSet remoteColumn) throws SQLException {
        JdbcTypeDescription jdbcTypeDescription = this.readJdbcTypeDescription(remoteColumn);
        String columnName = this.readColumnName(remoteColumn);
        String originalTypeName = this.readColumnTypeName(remoteColumn);
        String adapterNotes = ColumnAdapterNotesJsonConverter.getInstance().convertToJson(new ColumnAdapterNotes(jdbcTypeDescription.getJdbcType()));
        DataType exasolType = this.mapJdbcType(jdbcTypeDescription);
        return ColumnMetadata.builder().name(columnName).adapterNotes(adapterNotes).type(exasolType).nullable(this.isRemoteColumnNullable(remoteColumn, columnName)).identity(this.isAutoIncrementColumn(remoteColumn, columnName)).defaultValue(this.readDefaultValue(remoteColumn)).comment(this.readComment(remoteColumn)).originalTypeName(originalTypeName).build();
    }

    public JdbcTypeDescription readJdbcTypeDescription(ResultSet remoteColumn) throws SQLException {
        int jdbcType = this.readJdbcDataType(remoteColumn);
        int decimalScale = this.readScale(remoteColumn);
        int precisionOrSize = this.readPrecisionOrSize(remoteColumn);
        int charOctetLength = this.readOctetLength(remoteColumn);
        String typeName = this.readTypeName(remoteColumn);
        return new JdbcTypeDescription(jdbcType, decimalScale, precisionOrSize, charOctetLength, typeName);
    }

    private int readJdbcDataType(ResultSet remoteColumn) throws SQLException {
        return remoteColumn.getInt(DATA_TYPE_COLUMN);
    }

    private int readScale(ResultSet remoteColumn) throws SQLException {
        return remoteColumn.getInt(SCALE_COLUMN);
    }

    private int readPrecisionOrSize(ResultSet remoteColumn) throws SQLException {
        return remoteColumn.getInt(SIZE_COLUMN);
    }

    private int readOctetLength(ResultSet remoteColumn) throws SQLException {
        return remoteColumn.getInt(CHAR_OCTET_LENGTH_COLUMN);
    }

    private String readTypeName(ResultSet remoteColumn) throws SQLException {
        return remoteColumn.getString(TYPE_NAME_COLUMN);
    }

    protected boolean isRemoteColumnNullable(ResultSet remoteColumn, String columnName) {
        try {
            return !"no".equalsIgnoreCase(remoteColumn.getString(NULLABLE_COLUMN));
        }
        catch (SQLException exception) {
            LOGGER.warning(() -> "Caught an SQL exception trying to determine whether column \"" + columnName + "\" is nullable: " + exception.getMessage());
            LOGGER.warning(() -> "Assuming column \"" + columnName + "\" to be nullable.");
            return true;
        }
    }

    private boolean isAutoIncrementColumn(ResultSet remoteColumn, String columnName) {
        try {
            String identity = remoteColumn.getString(AUTOINCREMENT_COLUMN);
            return "yes".equalsIgnoreCase(identity);
        }
        catch (SQLException exception) {
            LOGGER.warning(() -> "Caught an SQL exception trying to determine whether column \"" + columnName + "\" is an auto-increment column: " + exception.getMessage());
            LOGGER.warning(() -> "Assuming that column \"" + columnName + "\" is not incremented automatically.");
            return false;
        }
    }

    private String readDefaultValue(ResultSet remoteColumn) {
        try {
            if (remoteColumn.getString(DEFAULT_VALUE_COLUMN) != null) {
                return remoteColumn.getString(DEFAULT_VALUE_COLUMN);
            }
            return "";
        }
        catch (SQLException exception) {
            return "";
        }
    }

    private String readComment(ResultSet remoteColumn) {
        try {
            String comment = remoteColumn.getString(REMARKS_COLUMN);
            if (comment != null && !comment.isEmpty()) {
                return comment;
            }
            return "";
        }
        catch (SQLException exception) {
            return "";
        }
    }

    private String readColumnTypeName(ResultSet remoteColumn) throws SQLException {
        String columnTypeName = this.readTypeName(remoteColumn);
        return columnTypeName == null ? "" : columnTypeName;
    }

    protected String readColumnName(ResultSet columns) throws SQLException {
        return this.identifierConverter.convert(columns.getString(NAME_COLUMN));
    }

    @Override
    public DataType mapJdbcType(JdbcTypeDescription jdbcTypeDescription) {
        switch (jdbcTypeDescription.getJdbcType()) {
            case -6: 
            case 5: {
                return BaseColumnMetadataReader.convertSmallInteger(jdbcTypeDescription.getPrecisionOrSize());
            }
            case 4: {
                return BaseColumnMetadataReader.convertInteger(jdbcTypeDescription.getPrecisionOrSize());
            }
            case -5: {
                return BaseColumnMetadataReader.convertBigInteger(jdbcTypeDescription.getPrecisionOrSize());
            }
            case 3: {
                return this.convertDecimal(jdbcTypeDescription.getPrecisionOrSize(), jdbcTypeDescription.getDecimalScale());
            }
            case 6: 
            case 7: 
            case 8: {
                return DataType.createDouble();
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return BaseColumnMetadataReader.convertVarChar(jdbcTypeDescription.getPrecisionOrSize(), jdbcTypeDescription.getByteSize());
            }
            case -15: 
            case 1: {
                return BaseColumnMetadataReader.convertChar(jdbcTypeDescription.getPrecisionOrSize(), jdbcTypeDescription.getByteSize());
            }
            case 91: {
                return DataType.createDate();
            }
            case 93: {
                return DataType.createTimestamp((boolean)false);
            }
            case -7: 
            case 16: {
                return DataType.createBool();
            }
            case -2: 
            case 2: 
            case 92: 
            case 2005: {
                return BaseColumnMetadataReader.fallBackToMaximumSizeVarChar();
            }
        }
        LOGGER.finer("Found unsupported type: " + jdbcTypeDescription.getJdbcType());
        return DataType.createUnsupported();
    }

    private static DataType convertSmallInteger(int jdbcPrecision) {
        int precision = jdbcPrecision == 0 ? 9 : jdbcPrecision;
        DataType colType = DataType.createDecimal((int)precision, (int)0);
        return colType;
    }

    private static DataType convertInteger(int jdbcPrecision) {
        DataType colType;
        if (jdbcPrecision <= 36) {
            int precision = jdbcPrecision == 0 ? 18 : jdbcPrecision;
            colType = DataType.createDecimal((int)precision, (int)0);
        } else {
            colType = BaseColumnMetadataReader.fallBackToMaximumSizeVarChar();
        }
        return colType;
    }

    private static DataType convertBigInteger(int jdbcPrecision) {
        DataType colType;
        if (jdbcPrecision <= 36) {
            int precision = jdbcPrecision == 0 ? 36 : jdbcPrecision;
            colType = DataType.createDecimal((int)precision, (int)0);
        } else {
            colType = BaseColumnMetadataReader.fallBackToMaximumSizeVarChar();
        }
        return colType;
    }

    protected DataType convertDecimal(int jdbcPrecision, int scale) {
        DataType colType = jdbcPrecision <= 36 ? DataType.createDecimal((int)jdbcPrecision, (int)scale) : BaseColumnMetadataReader.fallBackToMaximumSizeVarChar();
        return colType;
    }

    private static DataType fallBackToMaximumSizeVarChar() {
        return DataType.createMaximumSizeVarChar((DataType.ExaCharset)DataType.ExaCharset.UTF8);
    }

    private static DataType convertVarChar(int size, int octetLength) {
        DataType colType;
        DataType.ExaCharset charset;
        DataType.ExaCharset exaCharset = charset = octetLength == size ? DataType.ExaCharset.ASCII : DataType.ExaCharset.UTF8;
        if (size <= 2000000) {
            int precision = size == 0 ? 2000000 : size;
            colType = DataType.createVarChar((int)precision, (DataType.ExaCharset)charset);
        } else {
            colType = DataType.createVarChar((int)2000000, (DataType.ExaCharset)charset);
        }
        return colType;
    }

    private static DataType convertChar(int size, int octetLength) {
        DataType.ExaCharset charset;
        DataType.ExaCharset exaCharset = charset = octetLength == size ? DataType.ExaCharset.ASCII : DataType.ExaCharset.UTF8;
        DataType colType = size <= 2000 ? DataType.createChar((int)size, (DataType.ExaCharset)charset) : (size <= 2000000 ? DataType.createVarChar((int)size, (DataType.ExaCharset)charset) : DataType.createVarChar((int)2000000, (DataType.ExaCharset)charset));
        return colType;
    }

    protected DataType mapJdbcTypeNumericToDecimalWithFallbackToDouble(JdbcTypeDescription jdbcTypeDescription) {
        int decimalPrec = jdbcTypeDescription.getPrecisionOrSize();
        int decimalScale = jdbcTypeDescription.getDecimalScale();
        if (decimalPrec <= 36) {
            return DataType.createDecimal((int)decimalPrec, (int)decimalScale);
        }
        return DataType.createDouble();
    }

    protected DataType getNumberTypeFromProperty(String property) {
        String precisionAndScale;
        Pattern pattern = Pattern.compile("\\s*(\\d+)\\s*,\\s*(\\d+)\\s*");
        Matcher matcher = pattern.matcher(precisionAndScale = this.properties.get(property));
        if (matcher.matches()) {
            int precision = Integer.parseInt(matcher.group(1));
            int scale = Integer.parseInt(matcher.group(2));
            return DataType.createDecimal((int)precision, (int)scale);
        }
        throw new IllegalArgumentException("Unable to parse adapter property " + property + " value \"" + precisionAndScale + " into a number precision and scale. The required format is \"<precision>.<scale>\", where both are integer numbers.");
    }
}

