/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.jdbc;

import com.exasol.ExaConnectionInformation;
import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.jdbc.ConnectionDefinitionBuilder;
import java.util.logging.Logger;

public class BaseConnectionDefinitionBuilder
implements ConnectionDefinitionBuilder {
    private static final Logger LOGGER = Logger.getLogger(BaseConnectionDefinitionBuilder.class.getName());
    private static final String MISSING_CONNECTION_DETAILS_ERROR = "Incomplete remote connection information. Please specify either a named connection with CONNECTION_NAME or individual connetion properties CONNECTION_STRING, USERNAME and PASSWORD.";
    protected static final String CONFLICTING_CONNECTION_DETAILS_ERROR = "Mixing named connections in property CONNECTION_NAME and individual conneciton properties CONNECTION_STRING, USERNAME and PASSWORD is not allowed.";

    @Override
    public String buildConnectionDefinition(AdapterProperties properties, ExaConnectionInformation exaConnectionInformation) {
        if (this.hasIndividualConnectionPropertiesOnly(properties)) {
            return this.getConnectionFromPropertiesOnly(properties);
        }
        if (this.hasConflictingConnectionProperties(properties)) {
            throw new IllegalArgumentException(CONFLICTING_CONNECTION_DETAILS_ERROR);
        }
        if (properties.hasConnectionName()) {
            return this.getNamedConnection(properties);
        }
        throw new IllegalArgumentException(MISSING_CONNECTION_DETAILS_ERROR);
    }

    private String getConnectionFromPropertiesOnly(AdapterProperties properties) {
        this.warnConnectionPropertiesDeprecated();
        return this.getConnectionDefinition(properties.getConnectionString(), properties.getUsername(), properties.getPassword());
    }

    protected void warnConnectionPropertiesDeprecated() {
        LOGGER.warning(() -> "Defining credentials individually with properties is deprecated. Provide a connection name instead in property CONNECTION_NAME.");
    }

    protected String getConnectionDefinition(String connectionString, String username, String password) {
        return "AT '" + connectionString + "' USER '" + username + "' IDENTIFIED BY '" + password + "'";
    }

    protected boolean hasIndividualConnectionPropertiesOnly(AdapterProperties properties) {
        return !properties.hasConnectionName() && properties.hasConnectionString() && properties.hasUsername() && properties.hasPassword();
    }

    protected boolean hasConflictingConnectionProperties(AdapterProperties properties) {
        return properties.hasConnectionName() && (properties.hasConnectionString() || properties.hasUsername() || properties.hasPassword());
    }

    private String getNamedConnection(AdapterProperties properties) {
        return "AT " + properties.getConnectionName();
    }
}

