/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.jdbc;

import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.dialects.IdentifierConverter;
import com.exasol.adapter.jdbc.AbstractMetadataReader;
import com.exasol.adapter.jdbc.ColumnMetadataReader;
import com.exasol.adapter.jdbc.TableMetadataReader;
import com.exasol.adapter.metadata.ColumnMetadata;
import com.exasol.adapter.metadata.TableMetadata;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class BaseTableMetadataReader
extends AbstractMetadataReader
implements TableMetadataReader {
    static final String NAME_COLUMN = "TABLE_NAME";
    static final String REMARKS_COLUMN = "REMARKS";
    static final String DEFAULT_TABLE_ADAPTER_NOTES = "";
    private static final Logger LOGGER = Logger.getLogger(BaseTableMetadataReader.class.getName());
    private static final Pattern UNQUOTED_IDENTIFIER_PATTERN = Pattern.compile("^[a-z][0-9a-z_]*");
    protected ColumnMetadataReader columnMetadataReader;
    private final IdentifierConverter identifierConverter;

    public BaseTableMetadataReader(Connection connection, ColumnMetadataReader columnMetadataReader, AdapterProperties properties, IdentifierConverter identifierConverter) {
        super(connection, properties);
        this.columnMetadataReader = columnMetadataReader;
        this.identifierConverter = identifierConverter;
    }

    @Override
    public List<TableMetadata> mapTables(ResultSet remoteTables, Optional<List<String>> selectedTables) throws SQLException {
        ArrayList<TableMetadata> translatedTables = new ArrayList<TableMetadata>();
        if (remoteTables.next()) {
            do {
                this.mapOrSkipTable(remoteTables, translatedTables, selectedTables);
            } while (remoteTables.next());
        } else {
            LOGGER.warning(() -> "Table scan did not find any tables. This can mean that either a) the source does not contain tables (yet), b) the table type is not supported or c) the table scan filter criteria is incorrect. Please check that the source actually contains tables.  Also check the spelling and exact case of any catalog or schema name you provided.");
        }
        return translatedTables;
    }

    protected void mapOrSkipTable(ResultSet remoteTables, List<TableMetadata> translatedTables, Optional<List<String>> selectedTables) throws SQLException {
        String tableName = this.readTableName(remoteTables);
        if (this.isTableIncludedByMapping(tableName)) {
            this.mapSupportedTables(remoteTables, translatedTables, selectedTables, tableName);
        } else {
            this.skipUnsupportedTable(tableName);
        }
    }

    private void mapSupportedTables(ResultSet remoteTables, List<TableMetadata> translatedTables, Optional<List<String>> selectedTables, String tableName) throws SQLException {
        if (this.isTableSelected(tableName, selectedTables)) {
            this.mapOrSkipSelectedTable(remoteTables, translatedTables, tableName);
        } else {
            LOGGER.fine(() -> "Skipping filtered out table \"" + tableName + "\" when mapping remote metadata.");
        }
    }

    @Override
    public boolean isTableIncludedByMapping(String tableName) {
        return true;
    }

    protected boolean isTableSelected(String tableName, Optional<List<String>> selectedTables) {
        return selectedTables.isEmpty() || selectedTables.get().contains(tableName);
    }

    protected void mapOrSkipSelectedTable(ResultSet remoteTables, List<TableMetadata> translatedTables, String tableName) throws SQLException {
        if (this.isTableFilteredOut(tableName)) {
            this.skipFilteredTable(tableName);
        } else {
            this.mapTableNotFilteredOut(remoteTables, translatedTables, tableName);
        }
    }

    private boolean isTableFilteredOut(String tableName) {
        List filteredTables = this.properties.getFilteredTables();
        if (filteredTables.isEmpty()) {
            return false;
        }
        return !filteredTables.contains(tableName);
    }

    protected void skipFilteredTable(String tableName) {
        LOGGER.fine(() -> "Skipping table \"" + tableName + "\" when mapping remote data due to user-defined table filter");
    }

    protected void mapTableNotFilteredOut(ResultSet remoteTables, List<TableMetadata> translatedTables, String tableName) throws SQLException {
        TableMetadata tableMetadata = this.mapTable(remoteTables, tableName);
        if (tableMetadata.getColumns().isEmpty()) {
            this.skipTableWithEmptyColumns(tableName);
        } else {
            this.addMappedTable(translatedTables, tableMetadata);
        }
    }

    protected void skipTableWithEmptyColumns(String tableName) {
        LOGGER.fine(() -> "Not mapping table \"" + tableName + "\" because it has no columns. This can happen if the view containing the columns is invalid or if the Virtual Schema adapter does not support mapping the column types.");
    }

    protected void addMappedTable(List<TableMetadata> translatedTables, TableMetadata tableMetadata) {
        LOGGER.finer(() -> "Read table metadata: " + tableMetadata.describe());
        translatedTables.add(tableMetadata);
    }

    protected TableMetadata mapTable(ResultSet table, String tableName) throws SQLException {
        String comment = Optional.ofNullable(this.readComment(table)).orElse(DEFAULT_TABLE_ADAPTER_NOTES);
        List<ColumnMetadata> columns = this.columnMetadataReader.mapColumns(tableName);
        String adapterNotes = DEFAULT_TABLE_ADAPTER_NOTES;
        return new TableMetadata(this.adjustIdentifierCase(tableName), DEFAULT_TABLE_ADAPTER_NOTES, columns, comment);
    }

    private String adjustIdentifierCase(String tableName) {
        return this.identifierConverter.convert(tableName);
    }

    protected String readTableName(ResultSet remoteTables) throws SQLException {
        return remoteTables.getString(NAME_COLUMN);
    }

    protected String readComment(ResultSet remoteTables) throws SQLException {
        return remoteTables.getString(REMARKS_COLUMN);
    }

    protected boolean isUnquotedIdentifier(String identifier) {
        return UNQUOTED_IDENTIFIER_PATTERN.matcher(identifier).matches();
    }

    protected void skipUnsupportedTable(String tableName) {
        LOGGER.fine(() -> "Skipping unsupported table \"" + tableName + "\" when mapping remote metadata.");
    }
}

