/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.jdbc;

import com.exasol.ExaMetadata;
import com.exasol.adapter.AdapterException;
import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.VirtualSchemaAdapter;
import com.exasol.adapter.capabilities.AggregateFunctionCapability;
import com.exasol.adapter.capabilities.Capabilities;
import com.exasol.adapter.capabilities.LiteralCapability;
import com.exasol.adapter.capabilities.MainCapability;
import com.exasol.adapter.capabilities.PredicateCapability;
import com.exasol.adapter.capabilities.ScalarFunctionCapability;
import com.exasol.adapter.dialects.PropertyValidationException;
import com.exasol.adapter.dialects.SqlDialect;
import com.exasol.adapter.dialects.SqlDialectRegistry;
import com.exasol.adapter.jdbc.ConnectionFactory;
import com.exasol.adapter.jdbc.RemoteConnectionFactory;
import com.exasol.adapter.metadata.SchemaMetadata;
import com.exasol.adapter.metadata.SchemaMetadataInfo;
import com.exasol.adapter.request.AdapterRequest;
import com.exasol.adapter.request.CreateVirtualSchemaRequest;
import com.exasol.adapter.request.DropVirtualSchemaRequest;
import com.exasol.adapter.request.GetCapabilitiesRequest;
import com.exasol.adapter.request.PushDownRequest;
import com.exasol.adapter.request.RefreshRequest;
import com.exasol.adapter.request.SetPropertiesRequest;
import com.exasol.adapter.response.CreateVirtualSchemaResponse;
import com.exasol.adapter.response.DropVirtualSchemaResponse;
import com.exasol.adapter.response.GetCapabilitiesResponse;
import com.exasol.adapter.response.PushDownResponse;
import com.exasol.adapter.response.RefreshResponse;
import com.exasol.adapter.response.SetPropertiesResponse;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class JdbcAdapter
implements VirtualSchemaAdapter {
    private static final String SCALAR_FUNCTION_PREFIX = "FN_";
    private static final String PREDICATE_PREFIX = "FN_PRED_";
    private static final String AGGREGATE_FUNCTION_PREFIX = "FN_AGG_";
    private static final String LITERAL_PREFIX = "LITERAL_";
    private static final String TABLES_PROPERTY = "TABLE_FILTER";
    private static final Logger LOGGER = Logger.getLogger(JdbcAdapter.class.getName());

    public CreateVirtualSchemaResponse createVirtualSchema(ExaMetadata exasolMetadata, CreateVirtualSchemaRequest request) throws AdapterException {
        this.logCreateVirtualSchemaRequestReceived(request);
        AdapterProperties properties = this.getPropertiesFromRequest((AdapterRequest)request);
        try {
            SchemaMetadata remoteMeta = this.readMetadata(properties, exasolMetadata);
            return CreateVirtualSchemaResponse.builder().schemaMetadata(remoteMeta).build();
        }
        catch (SQLException exception) {
            throw new AdapterException("Unable create Virtual Schema \"" + request.getVirtualSchemaName() + "\". Cause: \"" + exception.getMessage(), (Exception)exception);
        }
    }

    protected void logCreateVirtualSchemaRequestReceived(CreateVirtualSchemaRequest request) {
        LOGGER.fine(() -> "Received request to create Virutal Schema \"" + request.getVirtualSchemaName() + "\".");
    }

    private AdapterProperties getPropertiesFromRequest(AdapterRequest request) {
        return new AdapterProperties(request.getSchemaMetadataInfo().getProperties());
    }

    private SchemaMetadata readMetadata(AdapterProperties properties, ExaMetadata exasolMetadata) throws SQLException, PropertyValidationException {
        List tables = properties.getFilteredTables();
        RemoteConnectionFactory connectionFactory = new RemoteConnectionFactory(exasolMetadata, properties);
        SqlDialect dialect = this.createDialect(connectionFactory, properties);
        dialect.validateProperties();
        if (tables.isEmpty()) {
            return dialect.readSchemaMetadata();
        }
        return dialect.readSchemaMetadata(tables);
    }

    protected SchemaMetadata readMetadata(AdapterProperties properties, List<String> whiteListedRemoteTables, ExaMetadata exasolMetadata) throws PropertyValidationException {
        RemoteConnectionFactory connectionFactory = new RemoteConnectionFactory(exasolMetadata, properties);
        SqlDialect dialect = this.createDialect(connectionFactory, properties);
        dialect.validateProperties();
        return dialect.readSchemaMetadata(whiteListedRemoteTables);
    }

    private SqlDialect createDialect(ConnectionFactory connectionFactory, AdapterProperties properties) {
        String dialectName = properties.getSqlDialect();
        return SqlDialectRegistry.getInstance().getDialectForName(dialectName, connectionFactory, properties);
    }

    public DropVirtualSchemaResponse dropVirtualSchema(ExaMetadata metadata, DropVirtualSchemaRequest request) {
        this.logDropVirtualSchemaRequestReceived(request);
        return DropVirtualSchemaResponse.builder().build();
    }

    protected void logDropVirtualSchemaRequestReceived(DropVirtualSchemaRequest request) {
        LOGGER.fine(() -> "Received request to drop Virutal Schema \"" + request.getVirtualSchemaName() + "\".");
    }

    public RefreshResponse refresh(ExaMetadata metadata, RefreshRequest request) throws AdapterException {
        SchemaMetadataInfo schemaMetadataInfo = request.getSchemaMetadataInfo();
        AdapterProperties properties = this.getPropertiesFromRequest((AdapterRequest)request);
        try {
            SchemaMetadata remoteMeta;
            if (request.refreshesOnlySelectedTables()) {
                List tables = request.getTables();
                remoteMeta = this.readMetadata(properties, tables, metadata);
            } else {
                remoteMeta = this.readMetadata(properties, metadata);
            }
            return RefreshResponse.builder().schemaMetadata(remoteMeta).build();
        }
        catch (SQLException exception) {
            throw new AdapterException("Unable refresh metadata of Virtual Schema \"" + schemaMetadataInfo.getSchemaName() + "\". Cause: " + exception.getMessage(), (Exception)exception);
        }
    }

    public SetPropertiesResponse setProperties(ExaMetadata metadata, SetPropertiesRequest request) throws AdapterException {
        Map requestRawProperties = request.getProperties();
        SchemaMetadataInfo schemaMetadataInfo = request.getSchemaMetadataInfo();
        Map<String, String> mergedRawProperties = this.mergeProperties(schemaMetadataInfo.getProperties(), requestRawProperties);
        AdapterProperties mergedProperties = new AdapterProperties(mergedRawProperties);
        if (AdapterProperties.isRefreshingVirtualSchemaRequired((Map)requestRawProperties)) {
            List<String> tableFilter = this.getTableFilter(mergedRawProperties);
            SchemaMetadata remoteMeta = this.readMetadata(mergedProperties, tableFilter, metadata);
            return SetPropertiesResponse.builder().schemaMetadata(remoteMeta).build();
        }
        return SetPropertiesResponse.builder().schemaMetadata(null).build();
    }

    private Map<String, String> mergeProperties(Map<String, String> previousRawProperties, Map<String, String> requestRawProperties) {
        HashMap<String, String> mergedRawProperties = new HashMap<String, String>(previousRawProperties);
        for (Map.Entry<String, String> requestRawProperty : requestRawProperties.entrySet()) {
            if (requestRawProperty.getValue() == null) {
                mergedRawProperties.remove(requestRawProperty.getKey());
                continue;
            }
            mergedRawProperties.put(requestRawProperty.getKey(), requestRawProperty.getValue());
        }
        return mergedRawProperties;
    }

    private List<String> getTableFilter(Map<String, String> properties) {
        String tableNames = properties.get(TABLES_PROPERTY);
        if (tableNames != null && !tableNames.isEmpty()) {
            List<String> tables = Arrays.asList(tableNames.split(","));
            for (int i = 0; i < tables.size(); ++i) {
                tables.set(i, tables.get(i).trim());
            }
            return tables;
        }
        return new ArrayList<String>();
    }

    public GetCapabilitiesResponse getCapabilities(ExaMetadata exaMetadata, GetCapabilitiesRequest request) throws AdapterException {
        LOGGER.fine(() -> "Received request to list the adapter's capabilites.");
        AdapterProperties properties = this.getPropertiesFromRequest((AdapterRequest)request);
        RemoteConnectionFactory connectionFactory = new RemoteConnectionFactory(exaMetadata, properties);
        SqlDialect dialect = this.createDialect(connectionFactory, properties);
        Capabilities capabilities = dialect.getCapabilities();
        Capabilities excludedCapabilities = this.getExcludedCapabilities(properties);
        capabilities.subtractCapabilities(excludedCapabilities);
        return GetCapabilitiesResponse.builder().capabilities(capabilities).build();
    }

    private Capabilities getExcludedCapabilities(AdapterProperties properties) {
        if (properties.containsKey("EXCLUDED_CAPABILITIES")) {
            String excludedCapabilitiesStr = properties.getExcludedCapabilities();
            Capabilities.Builder builder = this.parseExcludedCapabilities(excludedCapabilitiesStr);
            return builder.build();
        }
        LOGGER.config(() -> "Excluded Capabilities: none");
        return Capabilities.builder().build();
    }

    private Capabilities.Builder parseExcludedCapabilities(String excludedCapabilitiesString) {
        Capabilities.Builder builder = Capabilities.builder();
        LOGGER.config(() -> "Excluded Capabilities: " + (excludedCapabilitiesString.isEmpty() ? "none" : excludedCapabilitiesString));
        for (String capability : excludedCapabilitiesString.split(",")) {
            if ((capability = capability.trim()).isEmpty()) continue;
            if (capability.startsWith(LITERAL_PREFIX)) {
                String literalCapabilities = capability.replaceFirst(LITERAL_PREFIX, "");
                builder.addLiteral(new LiteralCapability[]{LiteralCapability.valueOf((String)literalCapabilities)});
                continue;
            }
            if (capability.startsWith(AGGREGATE_FUNCTION_PREFIX)) {
                String aggregateFunctionCap = capability.replaceFirst(AGGREGATE_FUNCTION_PREFIX, "");
                builder.addAggregateFunction(new AggregateFunctionCapability[]{AggregateFunctionCapability.valueOf((String)aggregateFunctionCap)});
                continue;
            }
            if (capability.startsWith(PREDICATE_PREFIX)) {
                String predicateCapabilities = capability.replaceFirst(PREDICATE_PREFIX, "");
                builder.addPredicate(new PredicateCapability[]{PredicateCapability.valueOf((String)predicateCapabilities)});
                continue;
            }
            if (capability.startsWith(SCALAR_FUNCTION_PREFIX)) {
                String scalarFunctionCapabilities = capability.replaceFirst(SCALAR_FUNCTION_PREFIX, "");
                builder.addScalarFunction(new ScalarFunctionCapability[]{ScalarFunctionCapability.valueOf((String)scalarFunctionCapabilities)});
                continue;
            }
            builder.addMain(new MainCapability[]{MainCapability.valueOf((String)capability)});
        }
        return builder;
    }

    public PushDownResponse pushdown(ExaMetadata exaMetadata, PushDownRequest request) throws AdapterException {
        try {
            AdapterProperties properties = this.getPropertiesFromRequest((AdapterRequest)request);
            RemoteConnectionFactory connectionFactory = new RemoteConnectionFactory(exaMetadata, properties);
            SqlDialect dialect = this.createDialect(connectionFactory, properties);
            String importFromPushdownQuery = dialect.rewriteQuery(request.getSelect(), exaMetadata);
            return PushDownResponse.builder().pushDownSql(importFromPushdownQuery).build();
        }
        catch (SQLException exception) {
            throw new AdapterException("Unable to execute push-down request. Cause: " + exception.getMessage(), (Exception)exception);
        }
    }
}

