/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.jdbc;

import com.exasol.ExaConnectionAccessException;
import com.exasol.ExaConnectionInformation;
import com.exasol.ExaMetadata;
import com.exasol.adapter.AdapterProperties;
import com.exasol.adapter.jdbc.ConnectionFactory;
import com.exasol.adapter.jdbc.RemoteConnectionException;
import com.exasol.auth.kerberos.KerberosConfigurationCreator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public final class RemoteConnectionFactory
implements ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(RemoteConnectionFactory.class.getName());
    private final ExaMetadata exaMetadata;
    private final AdapterProperties properties;
    private Connection cachedConnection = null;

    public RemoteConnectionFactory(ExaMetadata exaMetadata, AdapterProperties properties) {
        this.exaMetadata = exaMetadata;
        this.properties = properties;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.cachedConnection == null) {
            String connectionName = this.properties.getConnectionName();
            this.cachedConnection = connectionName != null && !connectionName.isEmpty() ? this.createConnection(connectionName, this.exaMetadata) : this.createConnectionWithUserCredentials(this.properties.getUsername(), this.properties.getPassword(), this.properties.getConnectionString());
        }
        return this.cachedConnection;
    }

    private Connection createConnectionWithUserCredentials(String username, String password, String connectionString) throws SQLException {
        this.logConnectionAttempt(username, password);
        long start = System.currentTimeMillis();
        Connection connection = DriverManager.getConnection(connectionString, username, password);
        this.logRemoteDatabaseDetails(connection, System.currentTimeMillis() - start);
        return connection;
    }

    protected void logConnectionAttempt(String address, String username) {
        LOGGER.fine(() -> "Connecting to \"" + address + "\" as user \"" + username + "\" using password authentication.");
    }

    protected void logRemoteDatabaseDetails(Connection connection, long connectionTime) throws SQLException {
        String databaseProductName = connection.getMetaData().getDatabaseProductName();
        String databaseProductVersion = connection.getMetaData().getDatabaseProductVersion();
        LOGGER.info(() -> "Connected to " + databaseProductName + " " + databaseProductVersion + " in " + connectionTime + " milliseconds.");
    }

    private Connection createConnection(String connectionName, ExaMetadata exaMetadata) throws SQLException {
        try {
            ExaConnectionInformation exaConnection = exaMetadata.getConnection(connectionName);
            String password = exaConnection.getPassword();
            String username = exaConnection.getUser();
            String address = exaConnection.getAddress();
            if (KerberosConfigurationCreator.isKerberosAuthentication(password)) {
                return this.establishConnectionWithKerberos(password, username, address);
            }
            return this.establishConnectionWithRegularCredentials(password, username, address);
        }
        catch (ExaConnectionAccessException exception) {
            throw new RemoteConnectionException("Could not access the connection information of connection \"" + connectionName + "\".", exception);
        }
    }

    private Connection establishConnectionWithKerberos(String password, String username, String address) throws SQLException {
        this.logConnectionAttemptWithKerberos(address, username);
        Properties jdbcProperties = new Properties();
        jdbcProperties.put("user", username);
        jdbcProperties.put("password", password);
        KerberosConfigurationCreator kerberosConfigurationCreator = new KerberosConfigurationCreator();
        kerberosConfigurationCreator.writeKerberosConfigurationFiles(username, password);
        long start = System.currentTimeMillis();
        Connection connection = DriverManager.getConnection(address, jdbcProperties);
        this.logRemoteDatabaseDetails(connection, System.currentTimeMillis() - start);
        return connection;
    }

    private void logConnectionAttemptWithKerberos(String address, String username) {
        LOGGER.fine(() -> "Connecting to \"" + address + "\" as user \"" + username + "\" using Kerberos authentication.");
    }

    private Connection establishConnectionWithRegularCredentials(String password, String username, String address) throws SQLException {
        this.logConnectionAttempt(address, username);
        long start = System.currentTimeMillis();
        Connection connection = DriverManager.getConnection(address, username, password);
        this.logRemoteDatabaseDetails(connection, System.currentTimeMillis() - start);
        return connection;
    }
}

