/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.adapter.jdbc;

import com.exasol.adapter.jdbc.ColumnMetadataReader;
import com.exasol.adapter.jdbc.JdbcTypeDescription;
import com.exasol.adapter.jdbc.RemoteMetadataReaderException;
import com.exasol.adapter.metadata.DataType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ResultSetMetadataReader {
    private static final Logger LOGGER = Logger.getLogger(ResultSetMetadataReader.class.getName());
    private final Connection connection;
    private final ColumnMetadataReader columnMetadataReader;

    public ResultSetMetadataReader(Connection connection, ColumnMetadataReader columnMetadataReader) {
        this.connection = connection;
        this.columnMetadataReader = columnMetadataReader;
    }

    public String describeColumns(String query) {
        String string;
        block8: {
            LOGGER.fine(() -> "Generating columns description for push-down query using " + this.columnMetadataReader.getClass().getSimpleName() + ":\n" + query);
            PreparedStatement statement = this.connection.prepareStatement(query);
            try {
                ResultSetMetaData metadata = statement.getMetaData();
                List<DataType> types = this.mapResultMetadataToExasolDataTypes(metadata);
                this.validateColumnTypes(types, query);
                String columnsDescription = this.createColumnDescriptionFromDataTypes(types);
                LOGGER.fine(() -> "Columns description: " + columnsDescription);
                string = columnsDescription;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    throw new RemoteMetadataReaderException("Unable to read remote metadata for push-down query trying to generate result column description. Caused by: " + exception.getMessage(), exception);
                }
            }
            statement.close();
        }
        return string;
    }

    private void validateColumnTypes(List<DataType> types, String query) {
        ArrayList<Integer> illegalColumns = new ArrayList<Integer>();
        int column = 1;
        for (DataType type : types) {
            if (!type.isSupported()) {
                illegalColumns.add(column);
            }
            ++column;
        }
        if (!illegalColumns.isEmpty()) {
            throw new RemoteMetadataReaderException("Unsupported data type(s) in column(s) " + illegalColumns.stream().map(String::valueOf).collect(Collectors.joining(", ")) + " in query. Please remove those colums from your query:\n" + query);
        }
    }

    private String createColumnDescriptionFromDataTypes(List<DataType> types) {
        StringBuilder builder = new StringBuilder();
        int columnNumber = 1;
        for (DataType type : types) {
            if (columnNumber > 1) {
                builder.append(", ");
            }
            builder.append("c");
            builder.append(columnNumber);
            builder.append(" ");
            builder.append(type.toString());
            ++columnNumber;
        }
        return builder.toString();
    }

    private List<DataType> mapResultMetadataToExasolDataTypes(ResultSetMetaData metadata) throws SQLException {
        int columnCount = metadata.getColumnCount();
        ArrayList<DataType> types = new ArrayList<DataType>(columnCount);
        for (int columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
            JdbcTypeDescription jdbcTypeDescription = ResultSetMetadataReader.getJdbcTypeDescription(metadata, columnNumber);
            DataType type = this.columnMetadataReader.mapJdbcType(jdbcTypeDescription);
            types.add(type);
        }
        return types;
    }

    protected static JdbcTypeDescription getJdbcTypeDescription(ResultSetMetaData metadata, int columnNumber) throws SQLException {
        int jdbcType = metadata.getColumnType(columnNumber);
        int jdbcPrecisions = metadata.getPrecision(columnNumber);
        int jdbcScales = metadata.getScale(columnNumber);
        return new JdbcTypeDescription(jdbcType, jdbcScales, jdbcPrecisions, 0, metadata.getColumnTypeName(columnNumber));
    }
}

