/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.auth.kerberos;

import com.exasol.auth.kerberos.KerberosConfigurationCreatorException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class KerberosConfigurationCreator {
    public static final String USE_SUBJECT_CREDENTIALS_ONLY_PROPERTY = "javax.security.auth.useSubjectCredsOnly";
    public static final String KERBEROS_CONFIG_PROPERTY = "java.security.krb5.conf";
    public static final String LOGIN_CONFIG_PROPERTY = "java.security.auth.login.config";
    public static final String KERBEROS_AUTHENTICATION_PREAMBLE = "ExaAuthType=Kerberos";
    private static final Logger LOGGER = Logger.getLogger(KerberosConfigurationCreator.class.getName());

    public static boolean isKerberosAuthentication(String password) {
        return password.startsWith(KERBEROS_AUTHENTICATION_PREAMBLE);
    }

    public void writeKerberosConfigurationFiles(String user, String password) {
        String[] tokens = password.split(";");
        String preamble = tokens[0];
        if (tokens.length != 3 || !KERBEROS_AUTHENTICATION_PREAMBLE.equals(preamble)) {
            throw new KerberosConfigurationCreatorException("Syntax error in Kerberos password. Must conform to: 'ExaAuthType=Kerberos;<base 64 kerberos config>;<base 64 key tab>'");
        }
        String base64EncodedKerberosConfig = tokens[1];
        String base64EncodedKeyTab = tokens[2];
        this.createKerberosConfiguration(user, base64EncodedKerberosConfig, base64EncodedKeyTab);
    }

    private void createKerberosConfiguration(String user, String base64EncodedKerberosConfig, String base64EncodedKeyTab) {
        try {
            Path temporaryDirectory = this.createCommonDirectoryForKerberosConfigurationFiles();
            Path kerberosConfigPath = this.createTemporaryKerberosConfigFile(base64EncodedKerberosConfig, temporaryDirectory);
            Path keyTabPath = this.createTemporaryKeyTabFile(base64EncodedKeyTab, temporaryDirectory);
            Path jaasConfigPath = this.createTemporaryJaasConfig(temporaryDirectory, user, keyTabPath);
            this.setKerberosSystemProperties(kerberosConfigPath, jaasConfigPath);
        }
        catch (IOException exception) {
            throw new KerberosConfigurationCreatorException("Unable to create temporary Kerberos configuration file.", exception);
        }
    }

    private Path createCommonDirectoryForKerberosConfigurationFiles() throws IOException {
        Path temporaryDirectory = Files.createTempDirectory("kerberos_", new FileAttribute[0]);
        temporaryDirectory.toFile().deleteOnExit();
        LOGGER.finer(() -> "Created temporary directory \"" + temporaryDirectory + "\" to contain Kerberos authentication files.");
        return temporaryDirectory;
    }

    private Path createTemporaryKerberosConfigFile(String base64EncodedKerberosConfig, Path temporaryDirectory) throws IOException {
        return this.createTemporaryFile(temporaryDirectory, "krb_", ".conf", DatatypeConverter.parseBase64Binary((String)base64EncodedKerberosConfig));
    }

    private Path createTemporaryKeyTabFile(String base64EncodedKeyTab, Path temporaryDirectory) throws IOException {
        return this.createTemporaryFile(temporaryDirectory, "kt_", ".keytab", DatatypeConverter.parseBase64Binary((String)base64EncodedKeyTab));
    }

    private Path createTemporaryFile(Path temporaryDirectory, String prefix, String suffix, byte[] content) throws IOException {
        Path temporaryFile = Files.createTempFile(temporaryDirectory, prefix, suffix, new FileAttribute[0]);
        temporaryFile.toFile().deleteOnExit();
        Files.write(temporaryFile, content, new OpenOption[0]);
        LOGGER.finer(() -> "Wrote " + content.length + " bytes to Kerberos configuration file \"" + temporaryFile + "\".");
        return temporaryFile;
    }

    private Path createTemporaryJaasConfig(Path temporaryDirectory, String user, Path keyTabPath) throws IOException {
        byte[] content = ("Client {\ncom.sun.security.auth.module.Krb5LoginModule required\nprincipal=\"" + user + "\"\nuseKeyTab=true\nkeyTab=\"" + keyTabPath + "\"\ndoNotPrompt=true\nuseTicketCache=false;\n};\ncom.sun.security.jgss.initiate {\ncom.sun.security.auth.module.Krb5LoginModule required\nprincipal=\"" + user + "\"\nuseKeyTab=true\nkeyTab=\"" + keyTabPath + "\"\ndoNotPrompt=true\nuseTicketCache=false;\n};\n").getBytes();
        return this.createTemporaryFile(temporaryDirectory, "jaas_", ".conf", content);
    }

    private void setKerberosSystemProperties(Path kerberosConfigPath, Path jaasConfigPath) {
        System.setProperty(KERBEROS_CONFIG_PROPERTY, kerberosConfigPath.toString());
        System.setProperty(LOGIN_CONFIG_PROPERTY, jaasConfigPath.toString());
        System.setProperty(USE_SUBJECT_CREDENTIALS_ONLY_PROPERTY, "false");
    }
}

