/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.blobs.stores.aws;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.expedia.blobs.core.BlobReadWriteException;
import com.expedia.blobs.core.BlobWriterImpl;
import com.expedia.blobs.core.io.AsyncSupport;
import com.expedia.blobs.core.io.BlobInputStream;
import com.expedia.blobs.core.support.CompressDecompressService;
import com.expedia.blobs.stores.aws.UploadProgressListener;
import com.expedia.www.blobs.model.Blob;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BlobStore
extends AsyncSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3BlobStore.class);
    private final String bucketName;
    private final TransferManager transferManager;
    private Thread shutdownHook = new Thread(() -> this.close());
    private final CompressDecompressService compressDecompressService;
    private static final String COMPRESSION_TYPE = "compressionType";
    @VisibleForTesting
    Boolean shutdownHookAdded = false;

    S3BlobStore(Builder builder) {
        super(builder.threadPoolSize, builder.shutdownWaitInSeconds);
        this.transferManager = builder.transferManager;
        this.bucketName = builder.bucketName;
        this.compressDecompressService = builder.compressDecompressService;
        if (builder.closeOnShutdown) {
            this.shutdownHookAdded = true;
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            LOGGER.info("No shutdown hook registered: Please call close() manually on application shutdown.");
        }
    }

    protected void storeInternal(BlobWriterImpl.BlobBuilder blobBuilder) {
        Blob blob = blobBuilder.build();
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            blob.getMetadataMap().forEach((arg_0, arg_1) -> ((ObjectMetadata)metadata).addUserMetadata(arg_0, arg_1));
            BlobInputStream blobInputStream = this.compressDecompressService.compressData(blob.getContent().toByteArray());
            metadata.addUserMetadata(COMPRESSION_TYPE, this.compressDecompressService.getCompressionType());
            metadata.setContentLength(blobInputStream.getLength());
            PutObjectRequest putRequest = (PutObjectRequest)new PutObjectRequest(this.bucketName, blob.getKey(), blobInputStream.getStream(), metadata).withCannedAcl(CannedAccessControlList.BucketOwnerFullControl).withGeneralProgressListener((ProgressListener)new UploadProgressListener(LOGGER, blob.getKey()));
            this.transferManager.upload(putRequest);
        }
        catch (Exception e) {
            String message = String.format("Unable to upload blob to S3 for  key %s : %s", blob.getKey(), e.getMessage());
            throw new BlobReadWriteException(message, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Optional<Blob> readInternal(String key) {
        try {
            S3Object s3Object = this.transferManager.getAmazonS3Client().getObject(this.bucketName, key);
            Map objectMetadata = s3Object.getObjectMetadata().getUserMetadata();
            Map metadata = objectMetadata == null ? new HashMap(0) : objectMetadata;
            CompressDecompressService.CompressionType compressionType = this.getCompressionType(metadata);
            S3ObjectInputStream is = s3Object.getObjectContent();
            try (InputStream uncompressedStream = CompressDecompressService.uncompressData((CompressDecompressService.CompressionType)compressionType, (InputStream)is);){
                Blob blob = Blob.newBuilder().setKey(key).putAllMetadata(metadata).setContent(ByteString.copyFrom((byte[])this.readInputStream(uncompressedStream))).build();
                Optional<Blob> optional = Optional.of(blob);
                return optional;
            }
        }
        catch (Exception e) {
            throw new BlobReadWriteException((Throwable)e);
        }
    }

    protected byte[] readInputStream(InputStream is) throws IOException {
        return IOUtils.toByteArray((InputStream)is);
    }

    CompressDecompressService.CompressionType getCompressionType(Map<String, String> metadata) {
        String compressionType = metadata.get(COMPRESSION_TYPE);
        compressionType = StringUtils.isEmpty((CharSequence)compressionType) ? "NONE" : compressionType;
        return CompressDecompressService.CompressionType.valueOf((String)compressionType.toUpperCase());
    }

    public void close() {
        super.close();
        this.transferManager.shutdownNow();
    }

    public static class Builder {
        private final String bucketName;
        private final TransferManager transferManager;
        private int threadPoolSize;
        private int shutdownWaitInSeconds;
        private boolean closeOnShutdown;
        private CompressDecompressService compressDecompressService;

        public Builder(String bucketName, TransferManager transferManager) {
            this.bucketName = bucketName;
            this.transferManager = transferManager;
            this.threadPoolSize = Runtime.getRuntime().availableProcessors();
            this.shutdownWaitInSeconds = 60;
            this.closeOnShutdown = true;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder withShutdownWaitInSeconds(int shutdownWaitInSeconds) {
            this.shutdownWaitInSeconds = shutdownWaitInSeconds;
            return this;
        }

        public Builder disableAutoShutdown() {
            this.closeOnShutdown = false;
            return this;
        }

        public Builder withCompressionType(CompressDecompressService.CompressionType compressionType) {
            this.compressDecompressService = new CompressDecompressService(compressionType);
            return this;
        }

        public S3BlobStore build() {
            Validate.notNull((Object)this.transferManager);
            Validate.notEmpty((String)this.bucketName);
            if (this.compressDecompressService == null) {
                this.compressDecompressService = new CompressDecompressService(CompressDecompressService.CompressionType.NONE);
            }
            return new S3BlobStore(this);
        }
    }
}

