/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.blobs.stores.aws;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;

class UploadProgressListener
implements ProgressListener {
    private final Logger logger;
    private final String key;

    UploadProgressListener(Logger logger, String objectKey) {
        Validate.notNull((Object)logger);
        this.logger = logger;
        Validate.notEmpty((String)objectKey);
        this.key = objectKey;
    }

    public void progressChanged(ProgressEvent progressEvent) {
        String msg = String.format("Progress event=%s file=%s transferred=%d", progressEvent.getEventType(), this.key, progressEvent.getBytesTransferred());
        switch (progressEvent.getEventType()) {
            case TRANSFER_FAILED_EVENT: 
            case TRANSFER_PART_FAILED_EVENT: {
                this.logger.error(msg);
                break;
            }
            default: {
                this.logger.info(msg);
            }
        }
    }
}

