/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.client.metrics.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.expedia.www.haystack.client.metrics.Counter;
import com.expedia.www.haystack.client.metrics.Gauge;
import com.expedia.www.haystack.client.metrics.MetricsRegistry;
import com.expedia.www.haystack.client.metrics.Tag;
import com.expedia.www.haystack.client.metrics.Timer;
import com.expedia.www.haystack.client.metrics.dropwizard.DropwizardCounter;
import com.expedia.www.haystack.client.metrics.dropwizard.DropwizardGauge;
import com.expedia.www.haystack.client.metrics.dropwizard.DropwizardTimer;
import com.expedia.www.haystack.client.metrics.dropwizard.NameMapper;
import java.util.Collection;
import java.util.function.ToDoubleFunction;

public class DropwizardMetricsRegistry
implements MetricsRegistry {
    private final MetricRegistry registry;
    private final NameMapper nameMapper;

    public DropwizardMetricsRegistry(MetricRegistry registry, NameMapper nameMapper) {
        this.registry = registry;
        this.nameMapper = nameMapper;
    }

    public <T> Gauge gauge(String name, Collection<Tag> tags, T obj, ToDoubleFunction<T> f) {
        com.codahale.metrics.Gauge gauge = () -> {
            if (obj != null) {
                return f.applyAsDouble(obj);
            }
            return Double.NaN;
        };
        this.registry.register(this.nameMapper.toName(name, tags), (Metric)gauge);
        return new DropwizardGauge((com.codahale.metrics.Gauge<Double>)gauge);
    }

    public Counter counter(String name, Collection<Tag> tags) {
        return new DropwizardCounter(this.registry.meter(this.nameMapper.toName(name, tags)));
    }

    public Timer timer(String name, Collection<Tag> tags) {
        return new DropwizardTimer(this.registry.timer(this.nameMapper.toName(name, tags)));
    }
}

