/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.client.metrics.dropwizard;

import com.codahale.metrics.Timer;
import com.expedia.www.haystack.client.metrics.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DropwizardTimer
implements Timer {
    private final com.codahale.metrics.Timer delegate;
    private final AtomicLong totalTime = new AtomicLong(0L);

    public DropwizardTimer(com.codahale.metrics.Timer delegate) {
        this.delegate = delegate;
    }

    public double totalTime(TimeUnit unit) {
        return unit.convert(this.totalTime.get(), TimeUnit.NANOSECONDS);
    }

    public long count() {
        return this.delegate.getCount();
    }

    public void record(long duration, TimeUnit unit) {
        this.delegate.update(duration, unit);
        this.totalTime.addAndGet(TimeUnit.NANOSECONDS.convert(duration, unit));
    }

    public Timer.Sample start() {
        return new DropwizardTimerSample(this.delegate.time());
    }

    public static class DropwizardTimerSample
    implements Timer.Sample {
        private final Timer.Context delegate;

        public DropwizardTimerSample(Timer.Context delegate) {
            this.delegate = delegate;
        }

        public long stop() {
            return this.delegate.stop();
        }
    }
}

