/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.client.metrics;

import com.expedia.www.haystack.client.metrics.MetricsRegistry;
import com.expedia.www.haystack.client.metrics.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.ToDoubleFunction;

public interface Gauge {
    public static <T> Builder<T> builder(String name, T obj, ToDoubleFunction<T> f) {
        return new Builder(name, obj, f);
    }

    public double value();

    public static class Builder<T> {
        private final String name;
        private final ToDoubleFunction<T> f;
        private final Collection<Tag> tags = new ArrayList<Tag>();
        private final T obj;

        private Builder(String name, T obj, ToDoubleFunction<T> f) {
            this.name = name;
            this.obj = obj;
            this.f = f;
        }

        public Builder<T> tags(Collection<Tag> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Builder<T> tag(Tag tag) {
            this.tags.add(tag);
            return this;
        }

        public Gauge register(MetricsRegistry registry) {
            return registry.gauge(this.name, this.tags, this.obj, this.f);
        }
    }
}

