/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.trace.commons.config.reload;

import com.expedia.www.haystack.commons.retries.RetryOperation;
import com.expedia.www.haystack.commons.retries.RetryOperation$;
import com.expedia.www.haystack.trace.commons.config.entities.ReloadConfiguration;
import com.expedia.www.haystack.trace.commons.config.reload.ConfigurationReloadProvider;
import com.expedia.www.haystack.trace.commons.config.reload.Reloadable;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001'\tA3i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r\\8bI\u0016c\u0017m\u001d;jGN+\u0017M]2i!J|g/\u001b3fe*\u00111\u0001B\u0001\u0007e\u0016dw.\u00193\u000b\u0005\u00151\u0011AB2p]\u001aLwM\u0003\u0002\b\u0011\u000591m\\7n_:\u001c(BA\u0005\u000b\u0003\u0015!(/Y2f\u0015\tYA\"\u0001\u0005iCf\u001cH/Y2l\u0015\tia\"A\u0002xo^T!a\u0004\t\u0002\u000f\u0015D\b/\u001a3jC*\t\u0011#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u001c\u0007>tg-[4ve\u0006$\u0018n\u001c8SK2|\u0017\r\u001a)s_ZLG-\u001a:\t\u0011e\u0001!\u0011!Q\u0001\ni\tAB]3m_\u0006$7i\u001c8gS\u001e\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0003\u0002\u0011\u0015tG/\u001b;jKNL!a\b\u000f\u0003'I+Gn\\1e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019C\u0005\u0005\u0002\u0016\u0001!)\u0011\u0004\ta\u00015!9a\u0005\u0001b\u0001\n\u00139\u0013!D7bi\u000eD\u0017\t\u001c7Rk\u0016\u0014\u00180F\u0001)!\tIc&D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012aa\u0015;sS:<\u0007BB\u0019\u0001A\u0003%\u0001&\u0001\bnCR\u001c\u0007.\u00117m#V,'/\u001f\u0011\t\u000fM\u0002!\u0019!C\u0005i\u0005AQm]\"mS\u0016tG/F\u00016!\t1T(D\u00018\u0015\tA\u0014(\u0001\u0004dY&,g\u000e\u001e\u0006\u0003um\n\u0011b]3be\u000eD'm\u001c=\u000b\u0003q\n!![8\n\u0005y:$A\u0003&fgR\u001cE.[3oi\"1\u0001\t\u0001Q\u0001\nU\n\u0011\"Z:DY&,g\u000e\u001e\u0011\t\u000b\t\u0003A\u0011I\"\u0002\t1|\u0017\r\u001a\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n!QK\\5u\u0011\u0015Y\u0005\u0001\"\u0011D\u0003\u0015\u0019Gn\\:f\u0001")
public class ConfigurationReloadElasticSearchProvider
extends ConfigurationReloadProvider {
    private final ReloadConfiguration reloadConfig;
    private final String matchAllQuery;
    private final JestClient esClient;

    private String matchAllQuery() {
        return this.matchAllQuery;
    }

    private JestClient esClient() {
        return this.esClient;
    }

    @Override
    public void load() {
        this.reloadConfig.observers().foreach((Function1 & Serializable & scala.Serializable)observer -> {
            ConfigurationReloadElasticSearchProvider.$anonfun$load$1(this, observer);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void close() {
        this.esClient().shutdownClient();
        super.close();
    }

    public static final /* synthetic */ void $anonfun$load$1(ConfigurationReloadElasticSearchProvider $this, Reloadable observer) {
        Search searchQuery = ((Search.Builder)((AbstractMultiTypeActionBuilder)new Search.Builder($this.matchAllQuery()).addIndex($this.reloadConfig.databaseName())).addType(observer.name())).build();
        Try try_ = RetryOperation$.MODULE$.executeWithRetryBackoff((Function0 & Serializable & scala.Serializable)() -> (SearchResult)$this.esClient().execute((Action)searchQuery), new RetryOperation.Config(3, 1000L, 2.0));
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Success success = (Success)try_;
            SearchResult result = (SearchResult)success.value();
            if (result.isSucceeded()) {
                $this.LOGGER().info(new StringBuilder(71).append("Reloading(or loading) is successfully done for the configuration name =").append(observer.name()).toString());
                observer.onReload(result.getSourceAsString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.LOGGER().error(new StringBuilder(66).append("Fail to reload the configuration from elastic search with error: ").append(result.getErrorMessage()).append(" ").append(new StringBuilder(18).append("for observer name=").append(observer.name()).toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable reason = failure.exception();
            $this.LOGGER().error(new StringBuilder(104).append("Fail to reload the configuration from elastic search for observer name=").append(observer.name()).append(". ").append("Will try at next scheduled time").toString(), reason);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public ConfigurationReloadElasticSearchProvider(ReloadConfiguration reloadConfig) {
        this.reloadConfig = reloadConfig;
        super(reloadConfig);
        this.matchAllQuery = "{\"query\":{\"match_all\":{\"boost\":1.0}}}";
        JestClientFactory factory = new JestClientFactory();
        HttpClientConfig.Builder builder = (HttpClientConfig.Builder)new HttpClientConfig.Builder(reloadConfig.configStoreEndpoint()).multiThreaded(false);
        Object object = reloadConfig.username().isDefined() && reloadConfig.password().isDefined() ? builder.defaultCredentials((String)reloadConfig.username().get(), (String)reloadConfig.password().get()) : BoxedUnit.UNIT;
        factory.setHttpClientConfig(builder.build());
        this.esClient = factory.getObject();
    }
}

