/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.trace.commons.config.reload;

import com.expedia.www.haystack.trace.commons.config.entities.ReloadConfiguration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E3Q!\u0001\u0002\u0002\u0002M\u00111dQ8oM&<WO]1uS>t'+\u001a7pC\u0012\u0004&o\u001c<jI\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0011X\r\\8bI*\u0011QAB\u0001\u0007G>tg-[4\u000b\u0005\u001dA\u0011aB2p[6|gn\u001d\u0006\u0003\u0013)\tQ\u0001\u001e:bG\u0016T!a\u0003\u0007\u0002\u0011!\f\u0017p\u001d;bG.T!!\u0004\b\u0002\u0007]<xO\u0003\u0002\u0010!\u00059Q\r\u001f9fI&\f'\"A\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001!B\u0004\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005!A.\u00198h\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\r=\u0013'.Z2u!\t)R$\u0003\u0002\u001f-\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016D\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006I\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0011\t\u0001\"\u001a8uSRLWm]\u0005\u0003K\t\u00121CU3m_\u0006$7i\u001c8gS\u001e,(/\u0019;j_:DQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u0015)a\u00051\u0001!\u0011\u001di\u0003A1A\u0005\u00129\na\u0001T(H\u000f\u0016\u0013V#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014!B:mMRR'\"\u0001\u001b\u0002\u0007=\u0014x-\u0003\u00027c\t1Aj\\4hKJDa\u0001\u000f\u0001!\u0002\u0013y\u0013a\u0002'P\u000f\u001e+%\u000b\t\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0003!)\u00070Z2vi>\u0014X#\u0001\u001f\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015AC2p]\u000e,(O]3oi*\u0011\u0011\tG\u0001\u0005kRLG.\u0003\u0002D}\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\r\u0015\u0003\u0001\u0015!\u0003=\u0003%)\u00070Z2vi>\u0014\b\u0005C\u0003H\u0001\u0019\u0005\u0001*\u0001\u0003m_\u0006$G#A%\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\tUs\u0017\u000e\u001e\u0005\u0006!\u0002!\t\u0001S\u0001\u0006G2|7/\u001a")
public abstract class ConfigurationReloadProvider
implements AutoCloseable {
    private final Logger LOGGER = LoggerFactory.getLogger(ConfigurationReloadProvider.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public Logger LOGGER() {
        return this.LOGGER;
    }

    private ScheduledExecutorService executor() {
        return this.executor;
    }

    public abstract void load();

    @Override
    public void close() {
        this.executor().shutdownNow();
    }

    public ConfigurationReloadProvider(ReloadConfiguration config) {
        Object object;
        if (config.reloadIntervalInMillis() > -1) {
            this.LOGGER().info("configuration reload scheduler has been started with a delay of {}ms", (Object)BoxesRunTime.boxToInteger((int)config.reloadIntervalInMillis()));
            object = this.executor().scheduleWithFixedDelay(() -> this.load(), config.reloadIntervalInMillis(), config.reloadIntervalInMillis(), TimeUnit.MILLISECONDS);
        } else {
            object = BoxedUnit.UNIT;
        }
    }
}

