/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.trace.commons.packer;

import com.expedia.open.tracing.buffer.SpanBuffer;
import com.expedia.www.haystack.trace.commons.packer.PackedMessage$;
import com.expedia.www.haystack.trace.commons.packer.PackedMetadata;
import com.expedia.www.haystack.trace.commons.packer.PackerType$;
import com.github.luben.zstd.ZstdInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.json4s.jackson.Serialization$;
import org.xerial.snappy.SnappyInputStream;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

public final class Unpacker$ {
    public static Unpacker$ MODULE$;

    static {
        new Unpacker$();
    }

    private byte[] readMetadata(byte[] packedDataBytes) {
        byte[] byArray;
        ByteBuffer byteBuffer = ByteBuffer.wrap(packedDataBytes);
        boolean magicBytesExist = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(PackedMessage$.MODULE$.MAGIC_BYTES())).indices().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> byteBuffer.get() == PackedMessage$.MODULE$.MAGIC_BYTES()[idx]);
        if (magicBytesExist) {
            int headerLength = byteBuffer.getInt();
            byte[] metadataBytes = new byte[headerLength];
            byteBuffer.get(metadataBytes, 0, headerLength);
            byArray = metadataBytes;
        } else {
            byArray = null;
        }
        return byArray;
    }

    private byte[] unpack(InputStream compressedStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)compressedStream, (OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpanBuffer readSpanBuffer(byte[] packedDataBytes) {
        byte[] parsedDataBytes = null;
        byte[] metadataBytes = this.readMetadata(packedDataBytes);
        if (metadataBytes != null) {
            PackedMetadata packedMetadata = (PackedMetadata)Serialization$.MODULE$.read(new String(metadataBytes), PackedMessage$.MODULE$.formats(), ManifestFactory$.MODULE$.classType(PackedMetadata.class));
            int compressedDataOffset = PackedMessage$.MODULE$.MAGIC_BYTES().length + 4 + metadataBytes.length;
            Enumeration.Value value = packedMetadata.t();
            Enumeration.Value value2 = PackerType$.MODULE$.SNAPPY();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                parsedDataBytes = this.unpack((InputStream)new SnappyInputStream((InputStream)new ByteArrayInputStream(packedDataBytes, compressedDataOffset, packedDataBytes.length - compressedDataOffset)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return SpanBuffer.parseFrom((byte[])parsedDataBytes);
            } else {
                Enumeration.Value value4 = PackerType$.MODULE$.GZIP();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    parsedDataBytes = this.unpack(new GZIPInputStream(new ByteArrayInputStream(packedDataBytes, compressedDataOffset, packedDataBytes.length - compressedDataOffset)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return SpanBuffer.parseFrom((byte[])parsedDataBytes);
                } else {
                    Enumeration.Value value6 = PackerType$.MODULE$.ZSTD();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) return SpanBuffer.parseFrom((InputStream)new ByteArrayInputStream(packedDataBytes, compressedDataOffset, packedDataBytes.length - compressedDataOffset));
                    parsedDataBytes = this.unpack((InputStream)new ZstdInputStream((InputStream)new ByteArrayInputStream(packedDataBytes, compressedDataOffset, packedDataBytes.length - compressedDataOffset)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            return SpanBuffer.parseFrom((byte[])parsedDataBytes);
        } else {
            parsedDataBytes = packedDataBytes;
        }
        return SpanBuffer.parseFrom((byte[])parsedDataBytes);
    }

    private Unpacker$() {
        MODULE$ = this;
    }
}

