/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.trace.commons.utils;

import com.expedia.open.tracing.Log;
import com.expedia.open.tracing.Span;
import com.expedia.open.tracing.Tag;
import com.expedia.www.haystack.trace.commons.utils.SpanMarkers$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class SpanUtils$ {
    public static SpanUtils$ MODULE$;
    private final String URL_TAG_KEY;

    static {
        new SpanUtils$();
    }

    public String URL_TAG_KEY() {
        return this.URL_TAG_KEY;
    }

    public long getEventTimestamp(Span span, String event) {
        return ((Log)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(span.getLogsList()).asScala()).find((Function1 & java.io.Serializable & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)SpanUtils$.$anonfun$getEventTimestamp$1(event, log))).get()).getTimestamp();
    }

    public long getEndTime(Span span) {
        return span.getStartTime() + span.getDuration();
    }

    public boolean isMergedSpan(Span span) {
        return this.containsClientLogTag(span) && this.containsServerLogTag(span);
    }

    /*
     * WARNING - void declaration
     */
    public String spanKind(Span span) {
        void var2_2;
        String kind;
        String string = kind = (String)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(span.getTagsList()).asScala()).find((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SpanUtils$.$anonfun$spanKind$1(x$1))).map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.getVStr()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (this.containsServerLogTag(span)) {
                return SpanMarkers$.MODULE$.SERVER_SPAN_KIND();
            }
            if (this.containsClientLogTag(span)) {
                return SpanMarkers$.MODULE$.CLIENT_SPAN_KIND();
            }
        }
        return var2_2;
    }

    public boolean containsServerLogTag(Span span) {
        return this.containsLogTag(span, SpanMarkers$.MODULE$.SERVER_RECV_EVENT()) && this.containsLogTag(span, SpanMarkers$.MODULE$.SERVER_SEND_EVENT());
    }

    public Option<Tag> getServiceTag(Span span) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(span.getTagsList()).asScala()).find((Function1 & java.io.Serializable & Serializable)tag -> BoxesRunTime.boxToBoolean((boolean)SpanUtils$.$anonfun$getServiceTag$1(tag)));
    }

    public boolean containsClientLogTag(Span span) {
        return this.containsLogTag(span, SpanMarkers$.MODULE$.CLIENT_RECV_EVENT()) && this.containsLogTag(span, SpanMarkers$.MODULE$.CLIENT_RECV_EVENT());
    }

    public Span addServerLogTag(Span span) {
        Log.Builder receiveEventLog = Log.newBuilder().setTimestamp(span.getStartTime()).addFields(Tag.newBuilder().setKey(SpanMarkers$.MODULE$.LOG_EVENT_TAG_KEY()).setVStr(SpanMarkers$.MODULE$.SERVER_RECV_EVENT()));
        Log.Builder sendEventLog = Log.newBuilder().setTimestamp(span.getStartTime() + span.getDuration()).addFields(Tag.newBuilder().setKey(SpanMarkers$.MODULE$.LOG_EVENT_TAG_KEY()).setVStr(SpanMarkers$.MODULE$.SERVER_SEND_EVENT()));
        return span.toBuilder().addLogs(receiveEventLog).addLogs(sendEventLog).build();
    }

    public Span addClientLogTag(Span span) {
        Log.Builder sendEventLog = Log.newBuilder().setTimestamp(span.getStartTime()).addFields(Tag.newBuilder().setType(Tag.TagType.STRING).setKey(SpanMarkers$.MODULE$.LOG_EVENT_TAG_KEY()).setVStr(SpanMarkers$.MODULE$.CLIENT_SEND_EVENT()));
        Log.Builder receiveEventLog = Log.newBuilder().setTimestamp(span.getStartTime() + span.getDuration()).addFields(Tag.newBuilder().setType(Tag.TagType.STRING).setKey(SpanMarkers$.MODULE$.LOG_EVENT_TAG_KEY()).setVStr(SpanMarkers$.MODULE$.CLIENT_RECV_EVENT()));
        return span.toBuilder().addLogs(sendEventLog).addLogs(receiveEventLog).build();
    }

    private boolean containsLogTag(Span span, String event) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(span.getLogsList()).asScala()).exists((Function1 & java.io.Serializable & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)SpanUtils$.$anonfun$containsLogTag$1(event, log)));
    }

    public Span.Builder createAutoGeneratedRootSpan(Seq<Span> spans, String reason, String rootSpanId) {
        Span.Builder builder;
        Span spanWithEarliestStartTime = (Span)spans.minBy((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getStartTime()), (Ordering)Ordering.Long$.MODULE$);
        Span spanWithLatestEndTime = (Span)spans.maxBy((Function1 & java.io.Serializable & Serializable)span -> BoxesRunTime.boxToLong((long)SpanUtils$.$anonfun$createAutoGeneratedRootSpan$2(span)), (Ordering)Ordering.Long$.MODULE$);
        long startTime = spanWithEarliestStartTime.getStartTime();
        long duration = spanWithLatestEndTime.getStartTime() + spanWithLatestEndTime.getDuration() - startTime;
        Span.Builder autoGenSpanBuilder = Span.newBuilder().setServiceName(spanWithEarliestStartTime.getServiceName()).setOperationName(SpanMarkers$.MODULE$.AUTOGEN_OPERATION_NAME()).setTraceId(spanWithEarliestStartTime.getTraceId()).setSpanId(rootSpanId).setParentSpanId("").setStartTime(startTime).setDuration(duration).addTags(Tag.newBuilder().setKey(SpanMarkers$.MODULE$.AUTOGEN_REASON_TAG()).setVStr(reason).setType(Tag.TagType.STRING)).addTags(Tag.newBuilder().setKey(SpanMarkers$.MODULE$.AUTOGEN_SPAN_ID_TAG()).setVStr(rootSpanId).setType(Tag.TagType.STRING)).addTags(Tag.newBuilder().setKey(SpanMarkers$.MODULE$.AUTOGEN_FLAG_TAG()).setVBool(true).setType(Tag.TagType.BOOL));
        Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spanWithEarliestStartTime.getTagsList()).asScala()).find((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SpanUtils$.$anonfun$createAutoGeneratedRootSpan$3(x$4)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Tag urlTag = (Tag)some.value();
            builder = autoGenSpanBuilder.addTags(urlTag);
        } else {
            builder = autoGenSpanBuilder;
        }
        return builder;
    }

    public static final /* synthetic */ boolean $anonfun$getEventTimestamp$2(String event$1, Tag tag) {
        return tag.getKey().equalsIgnoreCase(SpanMarkers$.MODULE$.LOG_EVENT_TAG_KEY()) && tag.getVStr().equalsIgnoreCase(event$1);
    }

    public static final /* synthetic */ boolean $anonfun$getEventTimestamp$1(String event$1, Log log) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(log.getFieldsList()).asScala()).exists((Function1 & java.io.Serializable & Serializable)tag -> BoxesRunTime.boxToBoolean((boolean)SpanUtils$.$anonfun$getEventTimestamp$2(event$1, tag)));
    }

    public static final /* synthetic */ boolean $anonfun$spanKind$1(Tag x$1) {
        String string = x$1.getKey();
        String string2 = SpanMarkers$.MODULE$.SPAN_KIND_TAG_KEY();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getServiceTag$1(Tag tag) {
        return tag.getKey().equalsIgnoreCase(SpanMarkers$.MODULE$.SERVICE_TAG_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$containsLogTag$2(String event$2, Tag tag) {
        return tag.getKey().equalsIgnoreCase(SpanMarkers$.MODULE$.LOG_EVENT_TAG_KEY()) && tag.getVStr().equalsIgnoreCase(event$2);
    }

    public static final /* synthetic */ boolean $anonfun$containsLogTag$1(String event$2, Log log) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(log.getFieldsList()).asScala()).exists((Function1 & java.io.Serializable & Serializable)tag -> BoxesRunTime.boxToBoolean((boolean)SpanUtils$.$anonfun$containsLogTag$2(event$2, tag)));
    }

    public static final /* synthetic */ long $anonfun$createAutoGeneratedRootSpan$2(Span span) {
        return span.getStartTime() + span.getDuration();
    }

    public static final /* synthetic */ boolean $anonfun$createAutoGeneratedRootSpan$3(Tag x$4) {
        return x$4.getKey().equalsIgnoreCase(MODULE$.URL_TAG_KEY());
    }

    private SpanUtils$() {
        MODULE$ = this;
        this.URL_TAG_KEY = "url";
    }
}

