/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import org.apache.parquet.Log;
import org.apache.parquet.SemanticVersion;
import org.apache.parquet.Strings;
import org.apache.parquet.VersionParser;
import org.apache.parquet.schema.PrimitiveType;

public class CorruptStatistics {
    private static final Log LOG = Log.getLog(CorruptStatistics.class);
    private static final SemanticVersion PARQUET_251_FIXED_VERSION = new SemanticVersion(1, 8, 0);

    public static boolean shouldIgnoreStatistics(String createdBy, PrimitiveType.PrimitiveTypeName columnType) {
        if (columnType != PrimitiveType.PrimitiveTypeName.BINARY && columnType != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            return false;
        }
        if (Strings.isNullOrEmpty(createdBy)) {
            LOG.info("Ignoring statistics because created_by is null or empty! See PARQUET-251 and PARQUET-297");
            return true;
        }
        try {
            VersionParser.ParsedVersion version = VersionParser.parse(createdBy);
            if (!"parquet-mr".equals(version.application)) {
                return false;
            }
            if (Strings.isNullOrEmpty(version.version)) {
                LOG.warn("Ignoring statistics because created_by did not contain a semver (see PARQUET-251): " + createdBy);
                return true;
            }
            SemanticVersion semver = SemanticVersion.parse(version.version);
            if (semver.compareTo(PARQUET_251_FIXED_VERSION) < 0) {
                LOG.info("Ignoring statistics because this file was created prior to " + PARQUET_251_FIXED_VERSION + ", see PARQUET-251");
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            CorruptStatistics.warnParseError(createdBy, e);
            return true;
        }
        catch (SemanticVersion.SemanticVersionParseException e) {
            CorruptStatistics.warnParseError(createdBy, e);
            return true;
        }
        catch (VersionParser.VersionParseException e) {
            CorruptStatistics.warnParseError(createdBy, e);
            return true;
        }
    }

    private static void warnParseError(String createdBy, Throwable e) {
        LOG.warn("Ignoring statistics because created_by could not be parsed (see PARQUET-251): " + createdBy, e);
    }
}

