/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.apiary.extensions.events.receiver.common.event;

import com.expediagroup.apiary.extensions.events.receiver.common.event.AddPartitionEvent;
import com.expediagroup.apiary.extensions.events.receiver.common.event.AlterPartitionEvent;
import com.expediagroup.apiary.extensions.events.receiver.common.event.AlterTableEvent;
import com.expediagroup.apiary.extensions.events.receiver.common.event.CreateTableEvent;
import com.expediagroup.apiary.extensions.events.receiver.common.event.DropPartitionEvent;
import com.expediagroup.apiary.extensions.events.receiver.common.event.DropTableEvent;
import com.expediagroup.apiary.extensions.events.receiver.common.event.InsertTableEvent;
import com.expediagroup.apiary.extensions.events.receiver.common.event.ListenerEvent;

public enum EventType {
    ADD_PARTITION(AddPartitionEvent.class),
    ALTER_PARTITION(AlterPartitionEvent.class),
    DROP_PARTITION(DropPartitionEvent.class),
    CREATE_TABLE(CreateTableEvent.class),
    INSERT(InsertTableEvent.class),
    DROP_TABLE(DropTableEvent.class),
    ALTER_TABLE(AlterTableEvent.class);

    private final Class<? extends ListenerEvent> eventClass;

    private EventType(Class<? extends ListenerEvent> eventClass) {
        if (eventClass == null) {
            throw new NullPointerException("Parameter eventClass is required");
        }
        this.eventClass = eventClass;
    }

    public Class<? extends ListenerEvent> eventClass() {
        return this.eventClass;
    }

    public static EventType forClass(Class<? extends ListenerEvent> clazz) {
        for (EventType e : EventType.values()) {
            if (!e.eventClass().equals(clazz)) continue;
            return e;
        }
        throw new IllegalArgumentException("EventType not found for class " + clazz.getName());
    }
}

