/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.apiary.extensions.events.receiver.common.messaging;

import com.expediagroup.apiary.extensions.events.receiver.common.error.SerDeException;
import com.expediagroup.apiary.extensions.events.receiver.common.event.EventType;
import com.expediagroup.apiary.extensions.events.receiver.common.event.ListenerEvent;
import com.expediagroup.apiary.extensions.events.receiver.common.messaging.MetaStoreEventDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMetaStoreEventDeserializer
implements MetaStoreEventDeserializer {
    private static final Logger log = LoggerFactory.getLogger(JsonMetaStoreEventDeserializer.class);
    private final ObjectMapper mapper;

    public JsonMetaStoreEventDeserializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T extends ListenerEvent> T unmarshal(String payload) throws SerDeException {
        try {
            log.debug("Marshalled event is: {}", (Object)payload);
            ListenerEvent genericEvent = (ListenerEvent)this.mapper.readerFor(HelperSerializableListenerEvent.class).readValue(payload);
            log.debug("Unmarshal event of type: {}", (Object)genericEvent.getEventType());
            ListenerEvent event = (ListenerEvent)this.mapper.readerFor(genericEvent.getEventType().eventClass()).readValue(payload);
            log.debug("Unmarshalled event is: {}", (Object)event);
            return (T)event;
        }
        catch (Exception e) {
            throw new SerDeException("Unable to unmarshal event from payload", e);
        }
    }

    static class HelperSerializableListenerEvent
    extends ListenerEvent {
        private static final long serialVersionUID = 1L;
        private EventType eventType;

        HelperSerializableListenerEvent() {
        }

        @Override
        public EventType getEventType() {
            return this.eventType;
        }

        public void setEventType(EventType eventType) {
            this.eventType = eventType;
        }

        @Override
        public String getDbName() {
            return null;
        }

        @Override
        public String getTableName() {
            return null;
        }
    }
}

