/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.locks.Lock;
import org.apache.twill.api.ElectionHandler;
import org.apache.twill.api.RunId;
import org.apache.twill.api.TwillContext;
import org.apache.twill.api.TwillRunnableSpecification;
import org.apache.twill.common.Cancellable;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.ServiceDiscovered;
import org.apache.twill.internal.ElectionRegistry;
import org.apache.twill.internal.zookeeper.ReentrantDistributedLock;
import org.apache.twill.zookeeper.ZKClient;

public final class BasicTwillContext
implements TwillContext {
    private final RunId runId;
    private final RunId appRunId;
    private final InetAddress host;
    private final String[] args;
    private final String[] appArgs;
    private final TwillRunnableSpecification spec;
    private final int instanceId;
    private final DiscoveryService discoveryService;
    private final DiscoveryServiceClient discoveryServiceClient;
    private final int allowedMemoryMB;
    private final int virtualCores;
    private final ZKClient zkClient;
    private final ElectionRegistry elections;
    private volatile int instanceCount;

    public BasicTwillContext(RunId runId, RunId appRunId, InetAddress host, String[] args, String[] appArgs, TwillRunnableSpecification spec, int instanceId, DiscoveryService discoveryService, DiscoveryServiceClient discoveryServiceClient, ZKClient zkClient, int instanceCount, int allowedMemoryMB, int virtualCores) {
        this.runId = runId;
        this.appRunId = appRunId;
        this.host = host;
        this.args = args;
        this.appArgs = appArgs;
        this.spec = spec;
        this.instanceId = instanceId;
        this.discoveryService = discoveryService;
        this.discoveryServiceClient = discoveryServiceClient;
        this.zkClient = zkClient;
        this.elections = new ElectionRegistry(zkClient);
        this.instanceCount = instanceCount;
        this.allowedMemoryMB = allowedMemoryMB;
        this.virtualCores = virtualCores;
    }

    public RunId getRunId() {
        return this.runId;
    }

    public RunId getApplicationRunId() {
        return this.appRunId;
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int count) {
        this.instanceCount = count;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public String[] getArguments() {
        return this.args;
    }

    public String[] getApplicationArguments() {
        return this.appArgs;
    }

    public TwillRunnableSpecification getSpecification() {
        return this.spec;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public int getVirtualCores() {
        return this.virtualCores;
    }

    public int getMaxMemoryMB() {
        return this.allowedMemoryMB;
    }

    public Cancellable announce(final String serviceName, final int port) {
        return this.discoveryService.register(new Discoverable(){

            public String getName() {
                return serviceName;
            }

            public InetSocketAddress getSocketAddress() {
                return new InetSocketAddress(BasicTwillContext.this.getHost(), port);
            }
        });
    }

    public ServiceDiscovered discover(String name) {
        return this.discoveryServiceClient.discover(name);
    }

    public Cancellable electLeader(String name, ElectionHandler participantHandler) {
        return this.elections.register("/leader/" + name, participantHandler);
    }

    public Lock createLock(String name) {
        return new ReentrantDistributedLock(this.zkClient, "/lock/" + name);
    }

    public void stop() {
        this.elections.shutdown();
    }
}

