/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.twill.api.LocalFile;
import org.apache.twill.internal.DefaultLocalFile;

public final class LocalFileCodec
implements JsonSerializer<LocalFile>,
JsonDeserializer<LocalFile> {
    public JsonElement serialize(LocalFile src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("name", src.getName());
        json.addProperty("uri", src.getURI().toASCIIString());
        json.addProperty("lastModified", (Number)src.getLastModified());
        json.addProperty("size", (Number)src.getSize());
        json.addProperty("archive", Boolean.valueOf(src.isArchive()));
        json.addProperty("pattern", src.getPattern());
        return json;
    }

    public LocalFile deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        String name = jsonObj.get("name").getAsString();
        URI uri = URI.create(jsonObj.get("uri").getAsString());
        long lastModified = jsonObj.get("lastModified").getAsLong();
        long size = jsonObj.get("size").getAsLong();
        boolean archive = jsonObj.get("archive").getAsBoolean();
        JsonElement pattern = jsonObj.get("pattern");
        return new DefaultLocalFile(name, uri, lastModified, size, archive, pattern == null || pattern.isJsonNull() ? null : pattern.getAsString());
    }
}

