/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.twill.api.EventHandlerSpecification;
import org.apache.twill.api.LocalFile;
import org.apache.twill.api.ResourceSpecification;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillRunnableSpecification;
import org.apache.twill.api.TwillSpecification;
import org.apache.twill.internal.json.LocalFileCodec;
import org.apache.twill.internal.json.ResourceSpecificationCodec;
import org.apache.twill.internal.json.RuntimeSpecificationCodec;
import org.apache.twill.internal.json.TwillRunnableSpecificationCodec;
import org.apache.twill.internal.json.TwillSpecificationCodec;

public final class TwillSpecificationAdapter {
    private final Gson gson = new GsonBuilder().serializeNulls().registerTypeAdapter(TwillSpecification.class, (Object)new TwillSpecificationCodec()).registerTypeAdapter(TwillSpecification.Order.class, (Object)new TwillSpecificationCodec.TwillSpecificationOrderCoder()).registerTypeAdapter(TwillSpecification.PlacementPolicy.class, (Object)new TwillSpecificationCodec.TwillSpecificationPlacementPolicyCoder()).registerTypeAdapter(EventHandlerSpecification.class, (Object)new TwillSpecificationCodec.EventHandlerSpecificationCoder()).registerTypeAdapter(RuntimeSpecification.class, (Object)new RuntimeSpecificationCodec()).registerTypeAdapter(TwillRunnableSpecification.class, (Object)new TwillRunnableSpecificationCodec()).registerTypeAdapter(ResourceSpecification.class, (Object)new ResourceSpecificationCodec()).registerTypeAdapter(LocalFile.class, (Object)new LocalFileCodec()).registerTypeAdapterFactory((TypeAdapterFactory)new TwillSpecificationTypeAdapterFactory()).create();

    public static TwillSpecificationAdapter create() {
        return new TwillSpecificationAdapter();
    }

    private TwillSpecificationAdapter() {
    }

    public String toJson(TwillSpecification spec) {
        return this.gson.toJson((Object)spec, TwillSpecification.class);
    }

    public void toJson(TwillSpecification spec, Writer writer) {
        this.gson.toJson((Object)spec, TwillSpecification.class, (Appendable)writer);
    }

    public void toJson(TwillSpecification spec, File file) throws IOException {
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);){
            this.toJson(spec, writer);
        }
    }

    public TwillSpecification fromJson(String json) {
        return (TwillSpecification)this.gson.fromJson(json, TwillSpecification.class);
    }

    public TwillSpecification fromJson(Reader reader) {
        return (TwillSpecification)this.gson.fromJson(reader, TwillSpecification.class);
    }

    public TwillSpecification fromJson(File file) throws IOException {
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            TwillSpecification twillSpecification = this.fromJson(reader);
            return twillSpecification;
        }
    }

    private static final class TwillSpecificationTypeAdapterFactory
    implements TypeAdapterFactory {
        private TwillSpecificationTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class rawType = type.getRawType();
            if (!Map.class.isAssignableFrom(rawType)) {
                return null;
            }
            Type[] typeArgs = ((ParameterizedType)type.getType()).getActualTypeArguments();
            TypeToken keyType = TypeToken.get((Type)typeArgs[0]);
            TypeToken valueType = TypeToken.get((Type)typeArgs[1]);
            if (keyType.getRawType() != String.class) {
                return null;
            }
            return this.mapAdapter(gson, valueType);
        }

        private <V> TypeAdapter<Map<String, V>> mapAdapter(Gson gson, TypeToken<V> valueType) {
            final TypeAdapter valueAdapter = gson.getAdapter(valueType);
            return new TypeAdapter<Map<String, V>>(){

                public void write(JsonWriter writer, Map<String, V> map) throws IOException {
                    if (map == null) {
                        writer.nullValue();
                        return;
                    }
                    writer.beginObject();
                    for (Map.Entry entry : map.entrySet()) {
                        writer.name(entry.getKey());
                        valueAdapter.write(writer, entry.getValue());
                    }
                    writer.endObject();
                }

                public Map<String, V> read(JsonReader reader) throws IOException {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                        return null;
                    }
                    HashMap map = Maps.newHashMap();
                    reader.beginObject();
                    while (reader.peek() != JsonToken.END_OBJECT) {
                        map.put(reader.nextName(), valueAdapter.read(reader));
                    }
                    reader.endObject();
                    return map;
                }
            };
        }
    }
}

