/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEventType;

public class AppAttemptRegisteredEvent
extends SystemMetricsEvent {
    private ApplicationAttemptId appAttemptId;
    private String host;
    private int rpcPort;
    private String trackingUrl;
    private String originalTrackingUrl;
    private ContainerId masterContainerId;

    public AppAttemptRegisteredEvent(ApplicationAttemptId appAttemptId, String host, int rpcPort, String trackingUrl, String originalTrackingUrl, ContainerId masterContainerId, long registeredTime) {
        super(SystemMetricsEventType.APP_ATTEMPT_REGISTERED, registeredTime);
        this.appAttemptId = appAttemptId;
        this.host = host;
        this.rpcPort = rpcPort;
        this.trackingUrl = trackingUrl;
        this.originalTrackingUrl = originalTrackingUrl;
        this.masterContainerId = masterContainerId;
    }

    public int hashCode() {
        return this.appAttemptId.getApplicationId().hashCode();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    public String getHost() {
        return this.host;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getOriginalTrackingURL() {
        return this.originalTrackingUrl;
    }

    public ContainerId getMasterContainerId() {
        return this.masterContainerId;
    }
}

