/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class IntArrayByteBufferConverter
implements TypeConverter<int[], ByteBuffer> {
    private static final long serialVersionUID = -426707949213710681L;

    @Override
    public ByteBuffer toDatastoreType(int[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = TypeConversionHelper.getByteArrayFromIntArray(memberValue);
        ByteBuffer byteBuffer = ByteBuffer.allocate(memberValue.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    @Override
    public int[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return TypeConversionHelper.getIntArrayFromByteArray(datastoreValue.array());
    }
}

